﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.IO;
using Microsoft.Extensions.Logging;
using Parser;

namespace Aiursoft.Parser.OBS
{
    public class OldEntry
    {
        private readonly CommandService _commandService;
        private readonly ILogger<OldEntry> logger;

        public OldEntry(
            CommandService commandService,
            ILogger<OldEntry> logger)
        {
            _commandService = commandService;
            this.logger = logger;
        }

        public async Task StartEntry(string[] args)
        {
            Console.WriteLine("Starting parser...");

            if (args.Length < 1)
            {
                Console.WriteLine("Usage: WorkingPath [useGPU]");
                Console.WriteLine("Current parameters:");
                foreach (var arg in args)
                {
                    Console.WriteLine(arg);
                }
                return;
            }

            var workingPath = args[0];
            var videos = Directory.EnumerateFiles(workingPath, "*.*", SearchOption.AllDirectories)
                .Where(v =>
                    v.EndsWith(".webm") ||
                    v.EndsWith(".mp4") ||
                    v.EndsWith(".avi") ||
                    v.EndsWith(".wmv") ||
                    v.EndsWith(".mkv"));

            foreach (var file in videos)
            {
                await Parse(file, coder: args.Any(a => a.Equals("useGPU", StringComparison.OrdinalIgnoreCase)) ? "hevc_nvenc" : "libx265");
            }
        }

        private async Task Parse(string filePath, string coder)
        {
            var folder = Path.GetDirectoryName(filePath) ?? throw new Exception($"{filePath} is invalid!");
            var baseFileInfo = await _commandService.RunCommand("ffmpeg", $@"-i ""{filePath}""", folder);
            var fileInfo = new FileInfo(filePath);
            var shouldParse =
                fileInfo.Length > 20 * 1024 * 1024 && // 20MB
                !baseFileInfo.Contains("Video: hevc") ||  // Not HEVC
                baseFileInfo.Contains("creation_time") || // Or contains privacy info
                !filePath.EndsWith(".mp4"); // Or not MP4
            var bareName = Path.GetFileNameWithoutExtension(filePath);
            var newFileName = $"{fileInfo.Directory}{Path.DirectorySeparatorChar}{bareName}_265.mp4";
            if (shouldParse)
            {
                Console.WriteLine($"{filePath} WILL be parsed!");

                File.Delete(newFileName);
                await _commandService.RunCommand("ffmpeg", $@"-i ""{filePath}"" -codec:a copy -codec:v {coder} -crf 20 ""{newFileName}""", folder, getOutput: false);

                if (File.Exists(newFileName))
                {
                    // Delete old file.
                    File.Delete(filePath);
                }
                else
                {
                    throw new Exception("After parsing, still couldn't locate the converted file: " + newFileName);
                }
            }
            else
            {
                Console.WriteLine($"{filePath} don't have to be parsed...");
            }
        }
    }
}
