import { Button } from "@mui/material";
import { appWindow } from "@tauri-apps/api/window";
import {
  CloseRounded,
  CropSquareRounded,
  HorizontalRuleRounded,
} from "@mui/icons-material";

const LayoutControl = () => {
  const minWidth = 40;

  return (
    <>
      <Button
        size="small"
        sx={{ minWidth, svg: { transform: "scale(0.9)" } }}
        onClick={() => appWindow.minimize()}
      >
        <HorizontalRuleRounded fontSize="small" />
      </Button>

      <Button
        size="small"
        sx={{ minWidth, svg: { transform: "scale(0.9)" } }}
        onClick={() => appWindow.toggleMaximize()}
      >
        <CropSquareRounded fontSize="small" />
      </Button>

      <Button
        size="small"
        sx={{ minWidth, svg: { transform: "scale(1.05)" } }}
        onClick={() => appWindow.hide()}
      >
        <CloseRounded fontSize="small" />
      </Button>
    </>
  );
};

export default LayoutControl;
