// SPDX-FileCopyrightText: Copyright 2017 Citra Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QRegularExpression>
#include <QString>
#include <QValidator>

class Validation {
public:
    Validation()
        : room_name(room_name_regex), nickname(nickname_regex), ip(ip_regex), port(0, UINT16_MAX) {}

    ~Validation() = default;

    const QValidator* GetRoomName() const {
        return &room_name;
    }
    const QValidator* GetNickname() const {
        return &nickname;
    }
    const QValidator* GetIP() const {
        return &ip;
    }
    const QValidator* GetPort() const {
        return &port;
    }

private:
    /// room name can be alphanumeric and " " "_" "." and "-" and must have a size of 4-20
    QRegularExpression room_name_regex =
        QRegularExpression(QStringLiteral("^[a-zA-Z0-9._ -]{4,20}"));
    QRegularExpressionValidator room_name;

    /// nickname can be alphanumeric and " " "_" "." and "-" and must have a size of 4-20
    const QRegularExpression nickname_regex =
        QRegularExpression(QStringLiteral("^[a-zA-Z0-9._ -]{4,20}"));
    QRegularExpressionValidator nickname;

    /// ipv4 address only
    // TODO remove this when we support hostnames in direct connect
    QRegularExpression ip_regex = QRegularExpression(QStringLiteral(
        "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|"
        "2[0-4][0-9]|25[0-5])"));
    QRegularExpressionValidator ip;

    /// port must be between 0 and 65535
    QIntValidator port;
};
