package main

import "fmt"

// generateEnvvar generates key-value pairs, and this function converts key-value pairs into good env string.
// supports: bash, fish, powershell, cmd
// panic on error, because it seems to be unrecoverable.
func SerializeEnvvar(shellName string, asUniversalVar bool, kvPairs map[string]string) string {
	result, fmtStr := "", ""
	switch shellName {
	case "bash":
		fmtStr = "export %v='%v'"
		if asUniversalVar {
			panic("serializeEnvvar.NotSupportedError: doesn't support bash universal variable. ")
		}
		break
	case "fish":
		if asUniversalVar {
			fmtStr = "set -Ux %v '%v'"
		} else {
			fmtStr = "set -x %v '%v'"
		}
		break
	case "powershell":
		fmtStr = "Set-Variable -Name %v -Value '%v' -Scope Global"
		if asUniversalVar {
			panic("serializeEnvvar.NotSupportedError: doesn't support powershell universal variable. ")
		}
		break
	case "cmd":
		fmtStr = "set \"%v=%v\""
		if asUniversalVar {
			panic("serializeEnvvar.NotSupportedError: doesn't support cmd universal variable. ")
		}
		break
	default:
		panic("serializeEnvvar.InvalidArgument: shellName should be bash,fish,powershell,cmd, instead of " + shellName)
	}

	for k, v := range kvPairs {
		result += fmt.Sprintf(fmtStr, k, v) + "\n"
	}

	return result
}
