package main

import (
	"io/ioutil"
	"log"
	"os"
	"strings"
)

///////////////////////////// utils BEGIN
func panicErrorIfAny(err error, title string) {
	if err != nil {
		panic("[Error] on " + title + ": " + err.Error())
	}
}
// On error, return empty string
func targetFrameworkVersion2TargetFramework(oldVersion string) string {
	if oldVersion[:1] != "v" {
		return ""
	}
	return "net" + strings.ReplaceAll(oldVersion[1:], ".", "")
}
func stringFuck(s0 string) string {
	s1 := strings.ReplaceAll(s0, `\`, `/`)
	s2 := strings.ReplaceAll(s1, `"`, `'`)
	return strings.ToLower(s2)
}
func stringIndexInsensitive(s, substr string) int {
	return strings.Index(stringFuck(s), stringFuck(substr))
}
func stringContainsInsensitive(s, substr string) bool {
	return stringIndexInsensitive(s, substr) != -1
}
func stringReplaceOnceInsensitive(s, old, new string) string {
	pos := stringIndexInsensitive(s, old)
	if pos == -1 {
		panic("Deep LogicError: Can not find `" + old + "` in `" + s + "` (case insensitive). Please contact author with your csproj file. ")
	}
	return s[0:pos] + new + s[pos+len(old):] // Sometimes len(old) != len(old_) !
}
///////////////////////////// utils END

// This is a naive tool to convert CoreXT csproj file to dotnet 5 csproj file.
// It should work on 99% well-formatted csproj file.
// |
// It's useful if you want to use OpenXT in pipeline, but not willing to touch your original csproj.
func main() {
	if(len(os.Args) < 2) {
		log.Println("Usage: csproj-to-5 path/to/your/project.csproj")
		os.Exit(1)
	}

	fname := os.Args[1]
	content, err := ioutil.ReadFile(fname)
	panicErrorIfAny(err, "read file " + fname)

	// Good luck for old MacOS! They use single \r as newline.
	lines := strings.Split(strings.ReplaceAll(string(content), "\r\n", "\n"), "\n")
	resultTxt := ""
	removeEndOfTagInNextLine := "" // Empty value indicates no need to remove EOT.
	for _, line := range lines {
		// We assume that, there's at most one issue in every line.
		// That's why this tool only works to well-formatted csproj, instead of any xml.
		// It's literally a bug.

		if stringContainsInsensitive(line, "<compile include=") {
			if ! strings.Contains(line, "..") {
				// Remove this <compile include>!
				if strings.Contains(line, "/>") {
					// Just remove this line
					continue
				} else {
					// Remove until tag close
					if removeEndOfTagInNextLine == "" {
						removeEndOfTagInNextLine = "</compile>"
					}
				}
			}
		}

		if stringContainsInsensitive(line, "(MSBuildToolsPath)\\Microsoft.CSharp.targets") {
			line = stringReplaceOnceInsensitive(line, "(MSBuildToolsPath)", "(ExtendedTargetsPath)")
		}

		if stringContainsInsensitive(line, "<TargetFrameworkVersion>") {
			// Remove this line
			lPos, rPos := stringIndexInsensitive(line, "<TargetFrameworkVersion>"), stringIndexInsensitive(line, "</TargetFrameworkVersion>")
			targetFramework := targetFrameworkVersion2TargetFramework(line[lPos + len("<TargetFrameworkVersion>") : rPos])
			if targetFramework == "" {
				panic("Invalid TargetFrameworkVersion: " + line[lPos + len("<TargetFrameworkVersion>") : rPos])
			}
			line = "<TargetFramework>" + targetFramework + "</TargetFramework><GenerateTargetFrameworkAttribute>false</GenerateTargetFrameworkAttribute>"
		}

		if stringContainsInsensitive(line, `DefaultTargets="Build"`) {
			line = stringReplaceOnceInsensitive(line, `DefaultTargets="Build"`, "")
		}

		if stringContainsInsensitive(line, "ToolsVersion=") {
			posBegin := stringIndexInsensitive(line, "ToolsVersion=")
			posEnd := posBegin + strings.IndexAny(line[posBegin:], " >")
			if posEnd == -1 {
				posEnd = len(line)
			}
			line = line[0:posBegin] + `Sdk="Microsoft.NET.Sdk"` + line[posEnd:]
		}

		if stringContainsInsensitive(line, `"System.ValueTuple"`) || stringContainsInsensitive(line, `$(PkgSystem_ValueTuple)`) {
			// Remove this line.
			if ! stringContainsInsensitive(line, "</Reference>") {
				// We need to remove more lines...
				if removeEndOfTagInNextLine == "" {
					removeEndOfTagInNextLine = "</Reference>"
				}
			}
			continue;
		}
		if removeEndOfTagInNextLine != "" {
			pos := stringIndexInsensitive(line, removeEndOfTagInNextLine);
			if pos == -1 {
				// this line still not contains </Reference>
				// Skip this line and keep checking next line.
				continue
	 		} else {
				line = line[pos+len(removeEndOfTagInNextLine):]
				removeEndOfTagInNextLine = ""
			}
		}

		resultTxt += line + "\n"
	}

	// patch: if the csproj has no <TargetFramework> and <TargetFrameworkVersion> at all, we must fix this error with a default targetFramework.
	if ! (stringContainsInsensitive(resultTxt, "<TargetFramework>") || stringContainsInsensitive(resultTxt, "<TargetFrameworkVersion>")) {
		resultTxt = stringReplaceOnceInsensitive(resultTxt, "<PropertyGroup>", "<PropertyGroup><TargetFramework>net472</TargetFramework><GenerateTargetFrameworkAttribute>false</GenerateTargetFrameworkAttribute>")
	}

	err = ioutil.WriteFile(fname, []byte(resultTxt), 0644)
	panicErrorIfAny(err, "WriteFile " + fname)
}
