package main

import (
	"io/ioutil"
	"log"
	"reflect"
	"strings"
)

func Filter(arr interface{}, cond func(interface{}) bool) interface{} {
	contentType := reflect.TypeOf(arr)
	contentValue := reflect.ValueOf(arr)

	newContent := reflect.MakeSlice(contentType, 0, 0)
	for i := 0; i < contentValue.Len(); i++ {
		if content := contentValue.Index(i); cond(content.Interface()) {
			newContent = reflect.Append(newContent, content)
		}
	}
	return newContent.Interface()
}

func logErrorIfAny(err error, title string) {
	if err != nil {
		log.Println("[Error] on " + title + ": " + err.Error())
	}
}
func panicErrorIfAny(err error, title string) {
	if err != nil {
		panic("[Error] on " + title + ": " + err.Error())
	}
}

func stringToTempFile(s string) (filename string, err error) {
	content := []byte(s)
	tmpfile, err := ioutil.TempFile("", "openxt.*.csproj")
	if err != nil {
		return
	}

	_, err = tmpfile.Write(content)
	if err != nil {
		return
	}
	err = tmpfile.Close()
	if err != nil {
		return
	}
	return tmpfile.Name(), nil
}

func assertStringNotEmpty(s, msg string) {
	if s == "" {
		panic(msg)
	}
}

// PkgCis_SdkV2 => Cis.SdkV2
// On error, returns empty string.
func guessPkgNameFromVarName(varName string) string {
	if len(varName) <= 3 || varName[:3] != "Pkg" {
		return ""
	}
	return strings.ReplaceAll(varName[3:], "_", ".")
}

