%option noyywrap

%{

#define YY_DECL int yylex()

#include "parser.tab.h"
#include <stdint.h>
#include <stdexcept>

%}

%%

[ \t\n]       {}
[0-9]+        {yylval.ival = atoi(yytext); return T_INT;}

"=="          {return T_EQ;}
"!="          {return T_NE;}
"&&"          {return T_AND;}
"||"          {return T_OR;}
">="          {return T_GE;}
"<="          {return T_LE;}
">"           {return T_GT;}
"<"           {return T_LT;}

[()!]      {return yytext[0];}

.             {throw std::runtime_error(std::string("lexer error around token: ") + yytext);}
%%
