/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.codegen;

import chocopy.common.Utils;
import chocopy.common.analysis.AbstractNodeAnalyzer;
import chocopy.common.analysis.SymbolTable;
import chocopy.common.analysis.types.SymbolType;
import chocopy.common.analysis.types.ValueType;
import chocopy.common.astnodes.BooleanLiteral;
import chocopy.common.astnodes.ClassDef;
import chocopy.common.astnodes.Declaration;
import chocopy.common.astnodes.FuncDef;
import chocopy.common.astnodes.GlobalDecl;
import chocopy.common.astnodes.IntegerLiteral;
import chocopy.common.astnodes.Literal;
import chocopy.common.astnodes.NonLocalDecl;
import chocopy.common.astnodes.Program;
import chocopy.common.astnodes.Stmt;
import chocopy.common.astnodes.TypedVar;
import chocopy.common.astnodes.VarDef;
import chocopy.common.codegen.AttrInfo;
import chocopy.common.codegen.ClassInfo;
import chocopy.common.codegen.Constants;
import chocopy.common.codegen.FuncInfo;
import chocopy.common.codegen.GlobalVarInfo;
import chocopy.common.codegen.Label;
import chocopy.common.codegen.RiscVBackend;
import chocopy.common.codegen.StackVarInfo;
import chocopy.common.codegen.SymbolInfo;
import chocopy.common.codegen.VarInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CodeGenBase {
    protected static final String LIBRARY_CODE_DIR = "chocopy/common/codegen/asm/";
    protected final RiscVBackend backend;
    protected final int wordSize;
    protected int nextTypeTag = 0;
    protected int nextLabelSuffix = 0;
    protected ClassInfo objectClass;
    protected ClassInfo intClass;
    protected ClassInfo boolClass;
    protected ClassInfo strClass;
    protected ClassInfo listClass;
    protected FuncInfo printFunc;
    protected FuncInfo lenFunc;
    protected FuncInfo inputFunc;
    protected final List<GlobalVarInfo> globalVars = new ArrayList<GlobalVarInfo>();
    protected final List<ClassInfo> classes = new ArrayList<ClassInfo>();
    protected final List<FuncInfo> functions = new ArrayList<FuncInfo>();
    protected final Label objectAllocLabel = new Label("alloc");
    protected final Label objectAllocResizeLabel = new Label("alloc2");
    protected final Label abortLabel = new Label("abort");
    protected final Label heapInitLabel = new Label("heap.init");
    protected final int ERROR_ARG = 1;
    protected final int ERROR_DIV_ZERO = 2;
    protected final int ERROR_OOB = 3;
    protected final int ERROR_NONE = 4;
    protected final int ERROR_OOM = 5;
    protected final int ERROR_NYI = 6;
    protected final int HEAP_SIZE_BYTES = 0x2000000;
    protected final int EXIT_ECALL = 10;
    protected final int EXIT2_ECALL = 17;
    protected final int PRINT_STRING_ECALL = 4;
    protected final int PRINT_CHAR_ECALL = 11;
    protected final int PRINT_INT_ECALL = 1;
    protected final int SBRK_ECALL = 9;
    protected final SymbolTable<SymbolInfo> globalSymbols = new SymbolTable();
    protected final Constants constants = new Constants();
    public static final int HEADER_SIZE = 3;
    private static final Pattern b = Pattern.compile("STRING\\[\"(.*?)\"\\]");

    public CodeGenBase(RiscVBackend backend) {
        this.backend = backend;
        this.wordSize = backend.getWordSize();
        this.initClasses();
        this.initFunctions();
        this.initAsmConstants();
    }

    protected int getNextTypeTag() {
        return this.nextTypeTag++;
    }

    protected int getNextLabelSuffix() {
        return this.nextLabelSuffix++;
    }

    protected Label generateLocalLabel() {
        return new Label(String.format("label_%d", this.getNextLabelSuffix()));
    }

    public void generate(Program program) {
        this.analyzeProgram(program);
        this.backend.startData();
        for (ClassInfo classInfo : this.classes) {
            this.emitPrototype(classInfo);
        }
        for (ClassInfo classInfo : this.classes) {
            this.emitDispatchTable(classInfo);
        }
        for (GlobalVarInfo global : this.globalVars) {
            this.backend.emitGlobalLabel(global.getLabel());
            this.emitConstant(global.getInitialValue(), global.getVarType(), String.format("Initial value of global var: %s", global.getVarName()));
        }
        this.backend.startCode();
        Label mainLabel = new Label("main");
        this.backend.emitGlobalLabel(mainLabel);
        this.backend.emitLUI(RiscVBackend.Register.A0, 8192, "Initialize heap size (in multiples of 4KB)");
        this.backend.emitADD(RiscVBackend.Register.S11, RiscVBackend.Register.S11, RiscVBackend.Register.A0, "Save heap size");
        this.backend.emitJAL(this.heapInitLabel, "Call heap.init routine");
        this.backend.emitMV(RiscVBackend.Register.GP, RiscVBackend.Register.A0, "Initialize heap pointer");
        this.backend.emitMV(RiscVBackend.Register.S10, RiscVBackend.Register.GP, "Set beginning of heap");
        this.backend.emitADD(RiscVBackend.Register.S11, RiscVBackend.Register.S10, RiscVBackend.Register.S11, "Set end of heap (= start of heap + heap size)");
        this.backend.emitMV(RiscVBackend.Register.RA, RiscVBackend.Register.ZERO, "No normal return from main program.");
        this.backend.emitMV(RiscVBackend.Register.FP, RiscVBackend.Register.ZERO, "No preceding frame.");
        this.emitTopLevel(program.statements);
        for (FuncInfo funcInfo : this.functions) {
            funcInfo.emitBody();
        }
        this.emitStdFunc("alloc");
        this.emitStdFunc("alloc2");
        this.emitStdFunc("abort");
        this.emitStdFunc("heap.init");
        this.emitCustomCode();
        this.backend.startData();
        this.emitConstants();
    }

    protected void initClasses() {
        FuncInfo objectInit = this.makeFuncInfo("object.__init__", 0, SymbolType.NONE_TYPE, this.globalSymbols, null, this::emitStdFunc);
        objectInit.addParam(this.makeStackVarInfo("self", SymbolType.OBJECT_TYPE, null, objectInit));
        this.functions.add(objectInit);
        this.objectClass = this.makeClassInfo("object", this.getNextTypeTag(), null);
        this.objectClass.addMethod(objectInit);
        this.classes.add(this.objectClass);
        this.globalSymbols.put(this.objectClass.getClassName(), this.objectClass);
        this.intClass = this.makeClassInfo("int", this.getNextTypeTag(), this.objectClass);
        this.intClass.addAttribute(this.makeAttrInfo("__int__", null, null));
        this.classes.add(this.intClass);
        this.globalSymbols.put(this.intClass.getClassName(), this.intClass);
        this.boolClass = this.makeClassInfo("bool", this.getNextTypeTag(), this.objectClass);
        this.boolClass.addAttribute(this.makeAttrInfo("__bool__", null, null));
        this.classes.add(this.boolClass);
        this.globalSymbols.put(this.boolClass.getClassName(), this.boolClass);
        this.strClass = this.makeClassInfo("str", this.getNextTypeTag(), this.objectClass);
        this.strClass.addAttribute(this.makeAttrInfo("__len__", SymbolType.INT_TYPE, new IntegerLiteral(null, null, 0)));
        this.strClass.addAttribute(this.makeAttrInfo("__str__", null, null));
        this.classes.add(this.strClass);
        this.globalSymbols.put(this.strClass.getClassName(), this.strClass);
        this.listClass = this.makeClassInfo(".list", -1, this.objectClass);
        this.listClass.addAttribute(this.makeAttrInfo("__len__", SymbolType.INT_TYPE, new IntegerLiteral(null, null, 0)));
        this.classes.add(this.listClass);
        this.listClass.dispatchTableLabel = null;
    }

    protected void initFunctions() {
        this.printFunc = this.makeFuncInfo("print", 0, SymbolType.NONE_TYPE, this.globalSymbols, null, this::emitStdFunc);
        this.printFunc.addParam(this.makeStackVarInfo("arg", SymbolType.OBJECT_TYPE, null, this.printFunc));
        this.functions.add(this.printFunc);
        this.globalSymbols.put(this.printFunc.getBaseName(), this.printFunc);
        this.lenFunc = this.makeFuncInfo("len", 0, SymbolType.INT_TYPE, this.globalSymbols, null, this::emitStdFunc);
        this.lenFunc.addParam(this.makeStackVarInfo("arg", SymbolType.OBJECT_TYPE, null, this.lenFunc));
        this.functions.add(this.lenFunc);
        this.globalSymbols.put(this.lenFunc.getBaseName(), this.lenFunc);
        this.inputFunc = this.makeFuncInfo("input", 0, SymbolType.STR_TYPE, this.globalSymbols, null, this::emitStdFunc);
        this.functions.add(this.inputFunc);
        this.globalSymbols.put(this.inputFunc.getBaseName(), this.inputFunc);
    }

    protected void initAsmConstants() {
        this.backend.defineSym("sbrk", 9);
        this.backend.defineSym("print_string", 4);
        this.backend.defineSym("print_char", 11);
        this.backend.defineSym("print_int", 1);
        this.backend.defineSym("exit2", 17);
        this.backend.defineSym(".__obj_size__", 4);
        this.backend.defineSym(".__len__", 12);
        this.backend.defineSym(".__int__", 12);
        this.backend.defineSym(".__bool__", 12);
        this.backend.defineSym(".__str__", 16);
        this.backend.defineSym(".__elts__", 16);
        this.backend.defineSym("error_div_zero", 2);
        this.backend.defineSym("error_arg", 1);
        this.backend.defineSym("error_oob", 3);
        this.backend.defineSym("error_none", 4);
        this.backend.defineSym("error_oom", 5);
        this.backend.defineSym("error_nyi", 6);
    }

    protected FuncInfo makeFuncInfo(String funcName, int depth, SymbolType returnType, SymbolTable<SymbolInfo> parentSymbolTable, FuncInfo parentFuncInfo, Consumer<FuncInfo> emitter) {
        return new FuncInfo(funcName, depth, returnType, parentSymbolTable, parentFuncInfo, emitter);
    }

    public ClassInfo makeClassInfo(String className, int typeTag, ClassInfo superClassInfo) {
        return new ClassInfo(className, typeTag, superClassInfo);
    }

    public AttrInfo makeAttrInfo(String attrName, ValueType attrType, Literal initialValue) {
        return new AttrInfo(attrName, attrType, initialValue);
    }

    public StackVarInfo makeStackVarInfo(String varName, ValueType varType, Literal initialValue, FuncInfo funcInfo) {
        return new StackVarInfo(varName, varType, initialValue, funcInfo);
    }

    public GlobalVarInfo makeGlobalVarInfo(String varName, ValueType varType, Literal initialValue) {
        return new GlobalVarInfo(varName, varType, initialValue);
    }

    protected void analyzeProgram(Program program) {
        for (Declaration decl : program.declarations) {
            if (!(decl instanceof VarDef)) continue;
            VarDef varDef = (VarDef)decl;
            ValueType varType = ValueType.annotationToValueType(varDef.var.type);
            GlobalVarInfo globalVar = this.makeGlobalVarInfo(varDef.var.identifier.name, varType, varDef.value);
            this.globalVars.add(globalVar);
            this.globalSymbols.put(globalVar.getVarName(), globalVar);
        }
        for (Declaration decl : program.declarations) {
            if (decl instanceof ClassDef) {
                ClassDef classDef = (ClassDef)decl;
                ClassInfo classInfo = this.analyzeClass(classDef);
                this.classes.add(classInfo);
                this.globalSymbols.put(classInfo.getClassName(), classInfo);
                continue;
            }
            if (!(decl instanceof FuncDef)) continue;
            FuncDef funcDef = (FuncDef)decl;
            FuncInfo funcInfo = this.analyzeFunction(null, funcDef, 0, this.globalSymbols, null);
            this.functions.add(funcInfo);
            this.globalSymbols.put(funcInfo.getBaseName(), funcInfo);
        }
    }

    protected ClassInfo analyzeClass(ClassDef classDef) {
        String className = classDef.name.name;
        String superClassName = classDef.superClass.name;
        SymbolInfo superSymbolInfo = this.globalSymbols.get(superClassName);
        assert (superSymbolInfo instanceof ClassInfo) : "Semantic analysis should ensure that super-class is defined";
        ClassInfo superClassInfo = (ClassInfo)superSymbolInfo;
        ClassInfo classInfo = this.makeClassInfo(className, this.getNextTypeTag(), superClassInfo);
        for (Declaration decl : classDef.declarations) {
            if (decl instanceof VarDef) {
                VarDef attrDef = (VarDef)decl;
                ValueType attrType = ValueType.annotationToValueType(attrDef.var.type);
                AttrInfo attrInfo = this.makeAttrInfo(attrDef.var.identifier.name, attrType, attrDef.value);
                classInfo.addAttribute(attrInfo);
                continue;
            }
            if (!(decl instanceof FuncDef)) continue;
            FuncDef funcDef = (FuncDef)decl;
            FuncInfo methodInfo = this.analyzeFunction(className, funcDef, 0, this.globalSymbols, null);
            this.functions.add(methodInfo);
            classInfo.addMethod(methodInfo);
        }
        return classInfo;
    }

    protected FuncInfo analyzeFunction(String container, FuncDef funcDef, int depth, SymbolTable<SymbolInfo> parentSymbolTable, FuncInfo parentFuncInfo) {
        String funcBaseName = funcDef.name.name;
        String funcQualifiedName = container != null ? String.format("%s.%s", container, funcBaseName) : funcBaseName;
        FuncInfo funcInfo = this.makeFuncInfo(funcQualifiedName, depth, ValueType.annotationToValueType(funcDef.returnType), parentSymbolTable, parentFuncInfo, this::emitUserDefinedFunction);
        for (TypedVar typedVar : funcDef.params) {
            ValueType paramType = ValueType.annotationToValueType(typedVar.type);
            StackVarInfo paramInfo = this.makeStackVarInfo(typedVar.identifier.name, paramType, null, funcInfo);
            funcInfo.addParam(paramInfo);
        }
        LocalDeclAnalyzer localDefs = new LocalDeclAnalyzer(funcInfo);
        for (Declaration decl : funcDef.declarations) {
            decl.dispatch(localDefs);
        }
        NestedFuncAnalyzer nestedFuncAnalyzer = new NestedFuncAnalyzer(funcInfo);
        for (Declaration decl : funcDef.declarations) {
            decl.dispatch(nestedFuncAnalyzer);
        }
        funcInfo.addBody(funcDef.statements);
        return funcInfo;
    }

    protected void alignObject() {
        int wordSizeLog2 = 31 - Integer.numberOfLeadingZeros(this.wordSize);
        this.backend.alignNext(wordSizeLog2);
    }

    protected void emitPrototype(ClassInfo classInfo) {
        this.backend.emitGlobalLabel(classInfo.getPrototypeLabel());
        this.backend.emitWordLiteral(classInfo.getTypeTag(), String.format("Type tag for class: %s", classInfo.getClassName()));
        this.backend.emitWordLiteral(classInfo.attributes.size() + 3, "Object size");
        this.backend.emitWordAddress(classInfo.getDispatchTableLabel(), "Pointer to dispatch table");
        for (VarInfo varInfo : classInfo.attributes) {
            String cmnt = String.format("Initial value of attribute: %s", varInfo.getVarName());
            this.emitConstant(varInfo.getInitialValue(), varInfo.getVarType(), cmnt);
        }
        this.alignObject();
    }

    protected void emitConstant(Literal value, ValueType type, String comment) {
        if (type != null && type.equals(SymbolType.INT_TYPE)) {
            this.backend.emitWordLiteral(((IntegerLiteral)value).value, comment);
        } else if (type != null && type.equals(SymbolType.BOOL_TYPE)) {
            this.backend.emitWordLiteral(((BooleanLiteral)value).value ? 1 : 0, comment);
        } else {
            this.backend.emitWordAddress(this.constants.fromLiteral(value), comment);
        }
    }

    protected void emitConstants() {
        Label label;
        Object value;
        this.backend.emitGlobalLabel(this.constants.a);
        this.backend.emitWordLiteral(this.boolClass.getTypeTag(), "Type tag for class: bool");
        this.backend.emitWordLiteral(this.boolClass.attributes.size() + 3, "Object size");
        this.backend.emitWordAddress(this.boolClass.getDispatchTableLabel(), "Pointer to dispatch table");
        this.backend.emitWordLiteral(0, "Constant value of attribute: __bool__");
        this.alignObject();
        this.backend.emitGlobalLabel(this.constants.b);
        this.backend.emitWordLiteral(this.boolClass.getTypeTag(), "Type tag for class: bool");
        this.backend.emitWordLiteral(this.boolClass.attributes.size() + 3, "Object size");
        this.backend.emitWordAddress(this.boolClass.getDispatchTableLabel(), "Pointer to dispatch table");
        this.backend.emitWordLiteral(1, "Constant value of attribute: __bool__");
        this.alignObject();
        for (Map.Entry<String, Label> entry : this.constants.d.entrySet()) {
            value = entry.getKey();
            label = entry.getValue();
            int numWordsForCharacters = ((String)value).length() / this.wordSize + 1;
            this.backend.emitGlobalLabel(label);
            this.backend.emitWordLiteral(this.strClass.getTypeTag(), "Type tag for class: str");
            this.backend.emitWordLiteral(4 + numWordsForCharacters, "Object size");
            this.backend.emitWordAddress(this.strClass.getDispatchTableLabel(), "Pointer to dispatch table");
            this.backend.emitWordLiteral(((String)value).length(), "Constant value of attribute: __len__");
            this.backend.emitString((String)value, "Constant value of attribute: __str__");
            this.alignObject();
        }
        for (Map.Entry<Object, Label> entry : this.constants.c.entrySet()) {
            value = (Integer)entry.getKey();
            label = entry.getValue();
            this.backend.emitGlobalLabel(label);
            this.backend.emitWordLiteral(this.intClass.getTypeTag(), "Type tag for class: int");
            this.backend.emitWordLiteral(this.intClass.attributes.size() + 3, "Object size");
            this.backend.emitWordAddress(this.intClass.getDispatchTableLabel(), "Pointer to dispatch table");
            this.backend.emitWordLiteral((Integer)value, "Constant value of attribute: __int__");
            this.alignObject();
        }
    }

    protected void emitDispatchTable(ClassInfo classInfo) {
        Label dispatchTableLabel = classInfo.getDispatchTableLabel();
        if (dispatchTableLabel == null) {
            return;
        }
        this.backend.emitGlobalLabel(dispatchTableLabel);
        for (FuncInfo method : classInfo.methods) {
            String cmnt = String.format("Implementation for method: %s.%s", classInfo.getClassName(), method.getBaseName());
            this.backend.emitWordAddress(method.getCodeLabel(), cmnt);
        }
    }

    protected int getTypeTagOffset() {
        return 0 * this.wordSize;
    }

    protected int getObjectSizeOffset() {
        return 1 * this.wordSize;
    }

    protected int getDispatchTableOffset() {
        return 2 * this.wordSize;
    }

    protected int getAttrOffset(ClassInfo classInfo, String attrName) {
        int attrIndex = classInfo.getAttributeIndex(attrName);
        assert (attrIndex >= 0) : "Type checker ensures that attributes are valid";
        return this.wordSize * (3 + attrIndex);
    }

    protected int getMethodOffset(ClassInfo classInfo, String methodName) {
        int methodIndex = classInfo.getMethodIndex(methodName);
        assert (methodIndex >= 0) : "Type checker ensures that attributes are valid";
        return this.wordSize * methodIndex;
    }

    protected abstract void emitTopLevel(List<Stmt> var1);

    protected abstract void emitUserDefinedFunction(FuncInfo var1);

    protected abstract void emitCustomCode();

    protected String getStandardLibraryCode(String name, String lib) {
        String simpleName = name.replace("$", "") + ".s";
        return Utils.getResourceFileAsString(lib + simpleName);
    }

    protected void emitStdFunc(Label label, String lib) {
        this.emitStdFunc(label, label.toString(), lib);
    }

    protected void emitStdFunc(Label label, String sourceFile, String lib) {
        String source = this.getStandardLibraryCode(sourceFile, lib);
        if (source == null) {
            throw Utils.fatal("Code for %s is missing.", sourceFile);
        }
        this.backend.emitGlobalLabel(label);
        this.backend.emit(this.a(source));
    }

    protected void emitStdFunc(Label label) {
        this.emitStdFunc(label, LIBRARY_CODE_DIR);
    }

    protected void emitStdFunc(String name, String lib) {
        this.emitStdFunc(new Label(name), lib);
    }

    protected void emitStdFunc(String name) {
        this.emitStdFunc(name, LIBRARY_CODE_DIR);
    }

    protected void emitStdFunc(FuncInfo funcInfo, String lib) {
        this.emitStdFunc(funcInfo.getCodeLabel(), lib);
    }

    protected void emitStdFunc(FuncInfo funcInfo) {
        this.emitStdFunc(funcInfo, LIBRARY_CODE_DIR);
    }

    private String a(String source) {
        Matcher matcher = b.matcher(source);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String r = this.constants.getStrConstant(matcher.group(1)).toString();
            matcher.appendReplacement(result, Utils.pad(r, Character.valueOf(' '), matcher.end(0) - matcher.start(0), false));
        }
        return matcher.appendTail(result).toString();
    }

    protected class NestedFuncAnalyzer
    extends AbstractNodeAnalyzer<Void> {
        private FuncInfo b;

        protected NestedFuncAnalyzer(FuncInfo funcInfo0) {
            this.b = funcInfo0;
        }

        @Override
        public Void analyze(FuncDef nestedFuncDef) {
            FuncInfo nestedFuncInfo = CodeGenBase.this.analyzeFunction(this.b.getFuncName(), nestedFuncDef, this.b.getDepth() + 1, this.b.getSymbolTable(), this.b);
            CodeGenBase.this.functions.add(nestedFuncInfo);
            this.b.getSymbolTable().put(nestedFuncInfo.getBaseName(), nestedFuncInfo);
            return null;
        }
    }

    protected class LocalDeclAnalyzer
    extends AbstractNodeAnalyzer<Void> {
        private FuncInfo c;

        protected LocalDeclAnalyzer(FuncInfo funcInfo0) {
            this.c = funcInfo0;
        }

        @Override
        public Void analyze(VarDef localVarDef) {
            ValueType localVarType = ValueType.annotationToValueType(localVarDef.var.type);
            StackVarInfo localVar = CodeGenBase.this.makeStackVarInfo(localVarDef.var.identifier.name, localVarType, localVarDef.value, this.c);
            this.c.addLocal(localVar);
            return null;
        }

        @Override
        public Void analyze(GlobalDecl decl) {
            SymbolInfo symInfo = CodeGenBase.this.globalSymbols.get(decl.getIdentifier().name);
            assert (symInfo instanceof GlobalVarInfo) : "Semantic analysis should ensure that global var exists";
            GlobalVarInfo globalVar = (GlobalVarInfo)symInfo;
            this.c.getSymbolTable().put(globalVar.getVarName(), globalVar);
            return null;
        }

        @Override
        public Void analyze(NonLocalDecl decl) {
            assert (this.c.getSymbolTable().get(decl.getIdentifier().name) instanceof StackVarInfo) : "Semantic analysis should ensure nonlocal var exists";
            return null;
        }
    }
}

