/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.codegen;

import chocopy.common.codegen.Label;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RiscVBackend {
    protected final StringWriter asmText = new StringWriter();
    private final PrintWriter c = new PrintWriter(this.asmText);
    protected static final int WORD_SIZE = 4;
    private HashMap<String, String> d = new HashMap();
    static final Pattern a = Pattern.compile("@(.[a-zA-Z_0-9.$]*)(?:\\s*([-+]\\d+))?|(#.*)|(\r?\n)");
    static final Pattern b = Pattern.compile("[-+]?\\d+");

    public String toString() {
        return this.asmText.toString();
    }

    protected String oldToString() {
        StringBuffer result = new StringBuffer();
        int deltaSpace = 0;
        Matcher refs = a.matcher(this.asmText.toString());
        while (refs.find()) {
            String repl;
            if (refs.group(3) != null) {
                repl = refs.group(3);
                refs.appendReplacement(result, "");
                while (deltaSpace < 0) {
                    result.append(" ");
                    ++deltaSpace;
                }
                result.append(repl);
                continue;
            }
            if (refs.group(4) != null) {
                deltaSpace = 0;
                refs.appendReplacement(result, refs.group(4));
                continue;
            }
            repl = this.d.get(refs.group(1));
            if (repl == null) {
                throw new IllegalStateException("undefined symbol: @" + refs.group(1));
            }
            if (refs.group(2) != null) {
                if (b.matcher(repl).matches()) {
                    int val = Integer.parseInt(repl) + Integer.parseInt(refs.group(2));
                    repl = Integer.toString(val);
                } else {
                    repl = repl + refs.group(2);
                }
            }
            refs.appendReplacement(result, repl);
            deltaSpace += repl.length() - refs.end(0) + refs.start(0);
        }
        refs.appendTail(result);
        return result.toString();
    }

    public void defineSym(String name, String value) {
        if (name.startsWith("@")) {
            this.emitInsn(String.format(".equiv %s, %s", name, value), null);
        } else {
            this.emitInsn(String.format(".equiv @%s, %s", name, value), null);
        }
    }

    public void defineSym(String name, int value) {
        this.defineSym(name, Integer.toString(value));
    }

    public int getWordSize() {
        return 4;
    }

    protected void emit(String str) {
        this.c.println(str);
    }

    public void emitInsn(String insn, String comment) {
        if (comment != null) {
            this.emit(String.format("  %-40s # %s", insn, comment));
        } else {
            this.emitInsn(insn);
        }
    }

    protected void emitInsn(String insn) {
        this.emit(String.format("  %s", insn));
    }

    public void emitLocalLabel(Label label, String comment) {
        if (comment != null) {
            this.emit(String.format("%-42s # %s", label + ":", comment));
        } else {
            this.emit(String.format("%s:", label + ":"));
        }
    }

    public void emitGlobalLabel(Label label) {
        this.emit(String.format("\n.globl %s", label));
        this.emit(String.format("%s:", label));
    }

    public void emitWordLiteral(Integer value, String comment) {
        this.emitInsn(String.format(".word %s", value), comment);
    }

    public void emitWordAddress(Label addr, String comment) {
        if (addr == null) {
            this.emitWordLiteral(0, comment);
        } else {
            this.emitInsn(String.format(".word %s", addr), comment);
        }
    }

    public void emitString(String value, String comment) {
        String quoted = value.replace("\\", "\\\\").replace("\n", "\\n").replace("\t", "\\t").replace("\"", "\\\"");
        this.emitInsn(String.format(".string \"%s\"", quoted), comment);
    }

    public void startData() {
        this.emit("\n.data");
    }

    public void startCode() {
        this.emit("\n.text");
    }

    public void alignNext(int pow) {
        this.emitInsn(String.format(".align %d", pow));
    }

    public void emitEcall(String comment) {
        this.emitInsn("ecall", comment);
    }

    public void emitLA(Register rd, Label label, String comment) {
        this.emitInsn(String.format("la %s, %s", new Object[]{rd, label}), comment);
    }

    public void emitLI(Register rd, Integer imm, String comment) {
        this.emitInsn(String.format("li %s, %d", new Object[]{rd, imm}), comment);
    }

    public void emitLUI(Register rd, Integer imm, String comment) {
        this.emitInsn(String.format("lui %s, %d", new Object[]{rd, imm}), comment);
    }

    public void emitMV(Register rd, Register rs, String comment) {
        this.emitInsn(String.format("mv %s, %s", new Object[]{rd, rs}), comment);
    }

    public void emitJR(Register rs, String comment) {
        this.emitInsn(String.format("jr %s", new Object[]{rs}), comment);
    }

    public void emitJ(Label label, String comment) {
        this.emitInsn(String.format("j %s", label), comment);
    }

    public void emitJAL(Label label, String comment) {
        this.emitInsn(String.format("jal %s", label), comment);
    }

    public void emitJALR(Register rs, String comment) {
        this.emitInsn(String.format("jalr %s", new Object[]{rs}), comment);
    }

    public void emitADDI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("addi %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitADDI(Register rd, Register rs, String imm, String comment) {
        this.emitInsn(String.format("addi %s, %s, %s", new Object[]{rd, rs, imm}), comment);
    }

    public void emitADD(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("add %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitSUB(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("sub %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitMUL(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("mul %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitDIV(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("div %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitREM(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("rem %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitXOR(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("xor %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitXORI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("xori %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitAND(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("and %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitANDI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("andi %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitOR(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("or %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitORI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("ori %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitSLL(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("sll %s, %s, %d", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitSLLI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("slli %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitSRL(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("srl %s, %s, %d", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitSRLI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("srli %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitSRA(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("sra %s, %s, %d", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitSRAI(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("srai %s, %s, %d", new Object[]{rd, rs, imm}), comment);
    }

    public void emitLW(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("lw %s, %d(%s)", new Object[]{rd, imm, rs}), comment);
    }

    public void emitLW(Register rd, Register rs, String imm, String comment) {
        this.emitInsn(String.format("lw %s, %s(%s)", new Object[]{rd, imm, rs}), comment);
    }

    public void emitSW(Register rs2, Register rs1, Integer imm, String comment) {
        this.emitInsn(String.format("sw %s, %d(%s)", new Object[]{rs2, imm, rs1}), comment);
    }

    public void emitSW(Register rs2, Register rs1, String imm, String comment) {
        this.emitInsn(String.format("sw %s, %s(%s)", new Object[]{rs2, imm, rs1}), comment);
    }

    public void emitLW(Register rd, Label label, String comment) {
        this.emitInsn(String.format("lw %s, %s", new Object[]{rd, label}), comment);
    }

    public void emitSW(Register rs, Label label, Register tmp, String comment) {
        this.emitInsn(String.format("sw %s, %s, %s", new Object[]{rs, label, tmp}), comment);
    }

    public void emitLB(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("lb %s, %d(%s)", new Object[]{rd, imm, rs}), comment);
    }

    public void emitLBU(Register rd, Register rs, Integer imm, String comment) {
        this.emitInsn(String.format("lbu %s, %d(%s)", new Object[]{rd, imm, rs}), comment);
    }

    public void emitSB(Register rs2, Register rs1, Integer imm, String comment) {
        this.emitInsn(String.format("sb %s, %d(%s)", new Object[]{rs2, imm, rs1}), comment);
    }

    public void emitBEQ(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("beq %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBNE(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("bne %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBGE(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("bge %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBGEU(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("bgeu %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBLT(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("blt %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBLTU(Register rs1, Register rs2, Label label, String comment) {
        this.emitInsn(String.format("bltu %s, %s, %s", new Object[]{rs1, rs2, label}), comment);
    }

    public void emitBEQZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("beqz %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitBNEZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("bnez %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitBLTZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("bltz %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitBGTZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("bgtz %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitBLEZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("blez %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitBGEZ(Register rs, Label label, String comment) {
        this.emitInsn(String.format("bgez %s, %s", new Object[]{rs, label}), comment);
    }

    public void emitSLT(Register rd, Register rs1, Register rs2, String comment) {
        this.emitInsn(String.format("slt %s, %s, %s", new Object[]{rd, rs1, rs2}), comment);
    }

    public void emitSEQZ(Register rd, Register rs, String comment) {
        this.emitInsn(String.format("seqz %s, %s", new Object[]{rd, rs}), comment);
    }

    public void emitSNEZ(Register rd, Register rs, String comment) {
        this.emitInsn(String.format("snez %s, %s", new Object[]{rd, rs}), comment);
    }

    public static enum Register {
        A0("a0"),
        A1("a1"),
        A2("a2"),
        A3("a3"),
        A4("a4"),
        A5("a5"),
        A6("a6"),
        A7("a7"),
        T0("t0"),
        T1("t1"),
        T2("t2"),
        T3("t3"),
        T4("t4"),
        T5("t5"),
        T6("t6"),
        S1("s1"),
        S2("s2"),
        S3("s3"),
        S4("s4"),
        S5("s5"),
        S6("s6"),
        S7("s7"),
        S8("s8"),
        S9("s9"),
        S10("s10"),
        S11("s11"),
        FP("fp"),
        SP("sp"),
        GP("gp"),
        RA("ra"),
        ZERO("zero");

        protected final String name;

        private Register(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

