#!/bin/bash

task="$1"
input="$2"
output="$3"

classPath="chocopy-ref.jar:target/assignment.jar"

if [[ "$task" = codegen ]]; then
    java -cp "$classPath" chocopy.ChocoPy --pass=rrs --out "$output" "$input"
elif [[ "$task" = codegen-ref ]]; then
    java -cp "$classPath" chocopy.ChocoPy --pass=rrr --out "$output" "$input"
elif [[ "$task" = ass ]]; then
    java -cp "$classPath" chocopy.ChocoPy --pass=..s --run --dir src/test/data/pa3/sample/ --test | tee /tmp/cs164_ass.log
    # Should pass all positive test, else return error_code=2
    # cat /tmp/cs164_ass.log | grep Test: | grep failed | grep -v sample/bad_ && exit 2 || exit 0
elif [[ "$task" = build ]]; then
    mvn clean package > /dev/null 2>&1 && echo success || echo failed
elif [[ "$task" = run ]]; then
    java -cp "$classPath" chocopy.ChocoPy --pass=rrs --run "$input"
fi

exit $?


