/*
 * Decompiled with CFR 0.152.
 */
package chocopy;

import chocopy.common.astnodes.CompilerError;
import chocopy.common.astnodes.Node;
import chocopy.common.astnodes.Program;
import chocopy.pa1.StudentParser;
import chocopy.pa2.StudentAnalysis;
import chocopy.pa3.StudentCodeGen;
import chocopy.reference.RefAnalysis;
import chocopy.reference.RefCodeGen;
import chocopy.reference.RefParser;
import chocopy.venus.Venus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class ChocoPy {
    private static final String[] a = new String[]{"r", "s", ".r", ".s", "..r", "..s", "rr", "rs", "sr", "ss", ".rr", ".rs", ".sr", ".ss", "rrr", "rrs", "rsr", "rss", "srr", "srs", "ssr", "sss"};
    private char[] b = new char[3];
    private boolean c;
    private boolean d;
    private Integer e;
    private List<String> f;
    private String g;
    private File h;
    private boolean i;
    private boolean j;
    private boolean k;
    private boolean l;
    private boolean m;
    private final String n = ".py";
    private final String o = ".ast";
    private final String p = ".typed";
    private final String q = ".s";
    private final String r = ".result";
    private int s = 0;
    private int t = 0;
    private int u = 0;
    private String v;
    private Program w;
    private String x;
    private static final Pattern y = Pattern.compile("(\"location\" *: *\\[ *\\d+ *, *\\d+)[ 0-9,]*");

    private void a(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)"ChocoPy").build().description("ChocoPy main driver");
        parser.addArgument(new String[]{"--pass"}).type(String.class).choices((Object[])a).setDefault((Object)"").help("Passes to run: 1-3 characters from ., s, or r");
        parser.addArgument(new String[]{"--run"}).action((ArgumentAction)Arguments.storeTrue()).help("Execute generated assembly (requires code generation)");
        parser.addArgument(new String[]{"--profile"}).action((ArgumentAction)Arguments.storeTrue()).help("Print number of cycles executed (requires --run)");
        parser.addArgument(new String[]{"--maxCycles"}).type(Integer.class).help("Terminate after executing given number of cycles (requires --run)");
        parser.addArgument(new String[]{"--reset"}).action((ArgumentAction)Arguments.storeTrue()).help("Regenerates all test outputs.  Should not be used unless you are the reference compiler implementor.");
        parser.addArgument(new String[]{"--update"}).action((ArgumentAction)Arguments.storeTrue()).help("Regenerates missing test outputs.  Should not be used unless you are the reference compiler implementor.");
        parser.addArgument(new String[]{"--test"}).action((ArgumentAction)Arguments.storeTrue()).help("Test against saved outputs.  Mainly used for regression testting.");
        parser.addArgument(new String[]{"--debug"}).action((ArgumentAction)Arguments.storeTrue()).help("Print debugging information.");
        parser.addArgument(new String[]{"source"}).nargs("*").type(String.class).help("Files to be compiled.");
        parser.addArgument(new String[]{"--directory"}).type(String.class).help("Directory containing the files to be compiled.  Mostly used for testing.");
        parser.addArgument(new String[]{"--out"}).type(String.class).help("Output file.");
        try {
            Namespace res = parser.parseArgs(args);
            String pass = res.get("pass") + "...";
            for (int i = 0; i < 3; ++i) {
                this.b[i] = pass.charAt(i);
            }
            this.c = (Boolean)res.get("run");
            this.d = (Boolean)res.get("profile");
            this.e = res.getInt("maxCycles");
            this.i = (Boolean)res.get("reset");
            this.k = (Boolean)res.get("test");
            this.j = (Boolean)res.get("update");
            this.l = (Boolean)res.get("debug");
            this.f = (List)res.get("source");
            this.g = (String)res.get("directory");
            this.h = res.getString("out") == null ? null : new File(res.getString("out"));
        }
        catch (ArgumentParserException e2) {
            parser.handleError(e2);
            System.exit(1);
        }
    }

    public void compile(String[] args) {
        this.m = false;
        this.a(args);
        if (this.b[0] == '.' && this.b[1] == '.' && this.b[2] == '.' && !this.c) {
            System.err.println("You must specify --pass or --run");
            System.exit(1);
        }
        for (String file : this.f) {
            this.b(file);
        }
        if (this.g != null) {
            try {
                String inputSuffix = this.b[0] != '.' ? ".py" : (this.b[1] != '.' ? ".ast" : (this.b[2] != '.' ? ".typed" : ".s"));
                Files.walk(Paths.get(this.g, new String[0]), new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.toString().endsWith(inputSuffix)).forEach(path -> this.b(path.normalize().toString()));
            }
            catch (IOException e2) {
                System.err.println("Failed to process " + this.g);
                e2.printStackTrace();
            }
        }
        if (this.f.isEmpty() && this.g == null) {
            System.err.println("You must specify something to compile.");
            System.exit(1);
        }
        if (this.k) {
            System.out.printf("Tests: %d passed, %d failed, and %d ignored.%n", this.t, this.s, this.u);
        } else if (this.m) {
            System.exit(1);
        }
    }

    private String a(String inputFileName) throws IOException {
        Scanner s = new Scanner(new File(inputFileName)).useDelimiter("\\Z");
        String str = s.hasNext() ? s.next() + "\n" : "";
        s.close();
        return str;
    }

    private void b(String inputFileName) {
        System.out.println("Reading " + inputFileName);
        try {
            this.v = this.a(inputFileName);
            this.x = inputFileName;
            this.w = null;
            this.a();
            this.b();
            String result = this.c();
            result = this.d(result);
            if (this.k || this.j || this.i) {
                this.c(inputFileName, result);
            } else {
                this.d(inputFileName, result);
            }
        }
        catch (RuntimeException e2) {
            System.err.printf("Unexpected exception: %s. Test failed.%n", e2);
            e2.printStackTrace();
            ++this.s;
        }
        catch (Error e3) {
            System.err.printf("Unexpected error: %s. Test failed.%n", e3);
            e3.printStackTrace();
            ++this.s;
        }
        catch (JsonProcessingException e4) {
            System.err.println("Input not a valid Program JSON");
            ++this.s;
        }
        catch (FileNotFoundException e5) {
            System.err.println("File not found: " + e5.getMessage());
            ++this.u;
        }
        catch (IOException e6) {
            System.err.println("Unexpected I/O exception! Test failed");
            e6.printStackTrace();
            ++this.s;
        }
    }

    private void a(String srcName, List<CompilerError> errors) {
        for (CompilerError err : errors) {
            int[] loc = err.getLocation();
            System.err.printf("%s:%d:%d: %s%n", srcName, loc[0], loc[1], err.message);
            this.m = true;
        }
    }

    private boolean a(String actualOutput, String expectedOutput) {
        try {
            JsonNode expectedJsonNode = Node.readTree(this.c(expectedOutput));
            JsonNode actualJsonNode = Node.readTree(this.c(actualOutput));
            return this.a(expectedJsonNode, actualJsonNode);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private String c(String json) {
        return y.matcher(json).replaceAll("$1, 0, 0 ");
    }

    private boolean b(String actualProgram, String expectedProgram) {
        try {
            String actualExecOutput = this.a(actualProgram, true);
            String expectedExecOutput = this.a(expectedProgram, true);
            return actualExecOutput.equals(expectedExecOutput);
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private void a(String inputFileName, String actualOutput, BiPredicate<String, String> comparator) throws IOException {
        File expectedFile = new File(this.x);
        if (this.i || this.j && !expectedFile.isFile()) {
            this.a(expectedFile, actualOutput);
        } else if (this.k) {
            if (expectedFile.isFile()) {
                String expectedOutput = new String(Files.readAllBytes(expectedFile.toPath()));
                if (comparator.test(actualOutput, expectedOutput)) {
                    System.out.println("+ Test: " + inputFileName + " passed");
                    ++this.t;
                } else {
                    System.out.println("- Test: " + inputFileName + " failed");
                    ++this.s;
                }
            } else {
                System.err.printf("File %s containing saved output for testing does not exist.%n", this.x);
                ++this.u;
            }
        } else if (!this.j && this.h != null && this.g == null && !this.f.isEmpty()) {
            this.a(this.h, actualOutput);
        }
    }

    private boolean a(JsonNode expectedJson, JsonNode actualJson) throws IOException {
        Program expectedProg = Node.fromJSON(expectedJson, Program.class);
        Program actualProg = Node.fromJSON(actualJson, Program.class);
        if (expectedProg.hasErrors() && actualProg.hasErrors()) {
            List<CompilerError> expectedErrors = expectedProg.getErrorList();
            List<CompilerError> actualErrors = actualProg.getErrorList();
            if (expectedErrors.isEmpty() != actualErrors.isEmpty()) {
                return false;
            }
            if (expectedErrors.isEmpty()) {
                return true;
            }
            CompilerError expected1 = expectedErrors.get(0);
            CompilerError actual1 = actualErrors.get(0);
            if (expected1.isSyntax() != actual1.isSyntax()) {
                return false;
            }
            if (expected1.isSyntax()) {
                return expected1.getLocation()[0] == actual1.getLocation()[0] && expected1.getLocation()[1] == actual1.getLocation()[1];
            }
            return new HashSet<CompilerError>(actualErrors).containsAll(new HashSet<CompilerError>(expectedErrors));
        }
        return expectedJson.equals((Object)actualJson);
    }

    private void a() throws IOException {
        if (this.b[0] != '.') {
            if (this.v == null) {
                this.w = null;
                return;
            }
            switch (this.b[0]) {
                case 's': {
                    this.w = StudentParser.process((String)this.v, (boolean)this.l);
                    break;
                }
                case 'r': {
                    this.w = RefParser.process(this.v, this.l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown pass 1 option");
                }
            }
            this.x = this.x + ".ast";
        } else if (this.b[1] != '.' || this.b[2] != '.') {
            this.w = Node.fromJSON(this.v, Program.class);
        }
    }

    private void b() {
        if (this.w != null && !this.w.hasErrors()) {
            switch (this.b[1]) {
                case '.': {
                    return;
                }
                case 's': {
                    this.w = StudentAnalysis.process((Program)this.w, (boolean)this.l);
                    break;
                }
                case 'r': {
                    this.w = RefAnalysis.process(this.w);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown pass 2 option");
                }
            }
            this.x = this.x + ".typed";
        }
    }

    private String c() {
        if (this.b[2] == '.') {
            if (this.b[0] == '.' && this.b[1] == '.') {
                return this.v;
            }
            if (this.w == null) {
                return "";
            }
            return this.w.toString();
        }
        if (this.w == null || this.w.hasErrors()) {
            return "";
        }
        this.x = this.x + ".s";
        switch (this.b[2]) {
            case 's': {
                return StudentCodeGen.process((Program)this.w, (boolean)this.l);
            }
            case 'r': {
                return RefCodeGen.process(this.w);
            }
        }
        throw new IllegalArgumentException("unknown pass 3 option");
    }

    private String d(String asmInput) {
        if (this.c && (this.w == null || !this.w.hasErrors())) {
            this.x = this.x + ".result";
            return this.a(asmInput, true);
        }
        return asmInput;
    }

    private void c(String inputFileName, String result) throws IOException {
        if (this.c) {
            this.a(inputFileName, result, (s1, s2) -> s1.trim().equals(s2.trim()));
        } else if (this.b[2] != '.') {
            this.a(inputFileName, result, this::b);
        } else {
            this.a(inputFileName, result, this::a);
        }
    }

    private void d(String inputFileName, String result) throws IOException {
        if (this.w != null) {
            this.a(inputFileName, this.w.getErrorList());
        }
        if (!this.c && this.h != null) {
            this.a(this.h, result);
        } else if (this.w == null || this.w != null && !this.w.hasErrors()) {
            System.out.println(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(String asmInput, boolean capture) {
        ByteArrayOutputStream buffer = null;
        PrintStream savedOut = System.out;
        try {
            if (capture) {
                buffer = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(buffer, true);
                System.setOut(out);
            }
            int cycles = Venus.assembleLinkAndRunWithCounter(asmInput, this.e);
            if (this.d) {
                System.out.printf("Cycles executed = %d%n", cycles);
            }
        }
        finally {
            System.setOut(savedOut);
        }
        return capture ? buffer.toString() : null;
    }

    private void a(File outFile, String text) throws FileNotFoundException {
        try (PrintWriter out = new PrintWriter(outFile);){
            out.print(text);
            System.err.printf("Created and saved output in %s.%n", outFile);
        }
    }

    public static void main(String[] args) throws IOException {
        ChocoPy cp = new ChocoPy();
        cp.compile(args);
    }

    public int getFailed() {
        return this.s;
    }

    public int getPassed() {
        return this.t;
    }

    public int getIgnored() {
        return this.u;
    }
}

