/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public class Utils {
    public static String getResourceFileAsString(String fileName) {
        InputStream is = Utils.class.getClassLoader().getResourceAsStream(fileName);
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return null;
    }

    public static Error fatal(String msgFormat, Object ... args) {
        return new Error(String.format(msgFormat, args));
    }

    public static String pad(String s, Character fill, int toLen, boolean padOnLeft) {
        StringBuilder result = new StringBuilder(toLen);
        if (!padOnLeft) {
            result.append(s);
        }
        for (int n = s.length(); n < toLen; ++n) {
            result.append(fill);
        }
        if (padOnLeft) {
            result.append(s);
        }
        return result.toString();
    }
}

