/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.codegen;

import chocopy.common.astnodes.BooleanLiteral;
import chocopy.common.astnodes.IntegerLiteral;
import chocopy.common.astnodes.Literal;
import chocopy.common.astnodes.NoneLiteral;
import chocopy.common.astnodes.StringLiteral;
import chocopy.common.codegen.Label;
import java.util.HashMap;
import java.util.Map;

public class Constants {
    protected int nextLabelSuffix = 0;
    final Label a = this.generateConstantLabel();
    final Label b = this.generateConstantLabel();
    final Map<Integer, Label> c = new HashMap<Integer, Label>();
    final Map<String, Label> d = new HashMap<String, Label>();

    protected int getNextLabelSuffix() {
        return this.nextLabelSuffix++;
    }

    public Label generateConstantLabel() {
        return new Label(String.format("const_%d", this.getNextLabelSuffix()));
    }

    public Label getBoolConstant(boolean value) {
        return value ? this.b : this.a;
    }

    public Label getIntConstant(int value) {
        if (this.c.containsKey(value)) {
            return this.c.get(value);
        }
        Label newLabel = this.generateConstantLabel();
        this.c.put(value, newLabel);
        return newLabel;
    }

    public Label getStrConstant(String value) {
        if (this.d.containsKey(value)) {
            return this.d.get(value);
        }
        Label newLabel = this.generateConstantLabel();
        this.d.put(value, newLabel);
        return newLabel;
    }

    public Label fromLiteral(Literal literal) {
        if (literal instanceof IntegerLiteral) {
            return this.getIntConstant(((IntegerLiteral)literal).value);
        }
        if (literal instanceof StringLiteral) {
            return this.getStrConstant(((StringLiteral)literal).value);
        }
        if (literal instanceof BooleanLiteral) {
            return this.getBoolConstant(((BooleanLiteral)literal).value);
        }
        assert (literal == null || literal instanceof NoneLiteral);
        return null;
    }
}

