/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.analysis.types;

import chocopy.common.analysis.types.SymbolType;
import chocopy.common.analysis.types.ValueType;
import chocopy.common.astnodes.ListType;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;

public class ListValueType
extends ValueType {
    public final ValueType elementType;

    @JsonCreator
    public ListValueType(SymbolType elementType) {
        this.elementType = (ValueType)elementType;
    }

    public ListValueType(ListType typeAnnotation) {
        this.elementType = ValueType.annotationToValueType(typeAnnotation.elementType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValueType listType = (ListValueType)o;
        return Objects.equals(this.elementType, listType.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.elementType);
    }

    public String toString() {
        return "[" + this.elementType.toString() + "]";
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public ValueType elementType() {
        return this.elementType;
    }
}

