/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.codegen;

import chocopy.common.codegen.AttrInfo;
import chocopy.common.codegen.FuncInfo;
import chocopy.common.codegen.Label;
import chocopy.common.codegen.SymbolInfo;
import java.util.ArrayList;
import java.util.List;

public class ClassInfo
extends SymbolInfo {
    protected final String className;
    public final List<AttrInfo> attributes;
    public final List<FuncInfo> methods;
    protected final int typeTag;
    protected Label prototypeLabel;
    protected Label dispatchTableLabel;

    public ClassInfo(String className, int typeTag, ClassInfo superClassInfo) {
        this.className = className;
        this.typeTag = typeTag;
        this.prototypeLabel = new Label(String.format("$%s$%s", className, "prototype"));
        this.dispatchTableLabel = new Label(String.format("$%s$%s", className, "dispatchTable"));
        this.attributes = new ArrayList<AttrInfo>();
        this.methods = new ArrayList<FuncInfo>();
        if (superClassInfo != null) {
            this.attributes.addAll(superClassInfo.attributes);
            this.methods.addAll(superClassInfo.methods);
        }
    }

    public void addAttribute(AttrInfo attrInfo) {
        this.attributes.add(attrInfo);
    }

    public void addMethod(FuncInfo funcInfo) {
        String methodName = funcInfo.getBaseName();
        int idx = this.getMethodIndex(methodName);
        if (idx >= 0) {
            this.methods.set(idx, funcInfo);
        } else {
            this.methods.add(funcInfo);
        }
    }

    public int getTypeTag() {
        return this.typeTag;
    }

    public Label getPrototypeLabel() {
        return this.prototypeLabel;
    }

    public Label getDispatchTableLabel() {
        return this.dispatchTableLabel;
    }

    public int getAttributeIndex(String attrName) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getVarName().equals(attrName)) continue;
            return i;
        }
        return -1;
    }

    public int getMethodIndex(String methodName) {
        for (int i = 0; i < this.methods.size(); ++i) {
            if (!this.methods.get(i).getBaseName().equals(methodName)) continue;
            return i;
        }
        return -1;
    }

    public String getClassName() {
        return this.className;
    }

    public List<AttrInfo> getAttributes() {
        return this.attributes;
    }

    public List<FuncInfo> getMethods() {
        return this.methods;
    }
}

