/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.astnodes;

import chocopy.common.analysis.NodeAnalyzer;
import chocopy.common.astnodes.CompilerError;
import chocopy.common.astnodes.Node;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java_cup.runtime.ComplexSymbolFactory;

public class Errors
extends Node {
    public final List<CompilerError> errors;
    @JsonIgnore
    private boolean allowMultipleErrors;

    @JsonCreator
    public Errors(List<CompilerError> errors) {
        super(null, null);
        this.errors = errors;
        this.allowMultipleErrors = true;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void suppressMultipleErrors() {
        this.allowMultipleErrors = false;
    }

    public void semError(Node node, String messageForm, Object ... args) {
        if (this.allowMultipleErrors || !node.hasError()) {
            String msg = String.format(messageForm, args);
            CompilerError err = new CompilerError(null, null, msg, false);
            err.setLocation(node.getLocation());
            this.add(err);
            if (!node.hasError()) {
                node.setErrorMsg(msg);
            }
        }
    }

    public void syntaxError(ComplexSymbolFactory.Location left, ComplexSymbolFactory.Location right, String messageForm, Object ... args) {
        this.add(new CompilerError(left, right, String.format(messageForm, args), true));
    }

    public void add(CompilerError err) {
        this.errors.add(err);
    }

    @Override
    public <T> T dispatch(NodeAnalyzer<T> analyzer) {
        return analyzer.analyze(this);
    }
}

