/*
 * Decompiled with CFR 0.152.
 */
package chocopy.reference.semantic;

import chocopy.common.analysis.AbstractNodeAnalyzer;
import chocopy.common.analysis.SymbolTable;
import chocopy.common.analysis.types.ClassValueType;
import chocopy.common.analysis.types.FuncType;
import chocopy.common.analysis.types.ListValueType;
import chocopy.common.analysis.types.SymbolType;
import chocopy.common.analysis.types.ValueType;
import chocopy.common.astnodes.AssignStmt;
import chocopy.common.astnodes.BinaryExpr;
import chocopy.common.astnodes.BooleanLiteral;
import chocopy.common.astnodes.CallExpr;
import chocopy.common.astnodes.ClassDef;
import chocopy.common.astnodes.Declaration;
import chocopy.common.astnodes.Errors;
import chocopy.common.astnodes.Expr;
import chocopy.common.astnodes.ExprStmt;
import chocopy.common.astnodes.ForStmt;
import chocopy.common.astnodes.FuncDef;
import chocopy.common.astnodes.Identifier;
import chocopy.common.astnodes.IfExpr;
import chocopy.common.astnodes.IfStmt;
import chocopy.common.astnodes.IndexExpr;
import chocopy.common.astnodes.IntegerLiteral;
import chocopy.common.astnodes.ListExpr;
import chocopy.common.astnodes.MemberExpr;
import chocopy.common.astnodes.MethodCallExpr;
import chocopy.common.astnodes.Node;
import chocopy.common.astnodes.NoneLiteral;
import chocopy.common.astnodes.Program;
import chocopy.common.astnodes.ReturnStmt;
import chocopy.common.astnodes.Stmt;
import chocopy.common.astnodes.StringLiteral;
import chocopy.common.astnodes.UnaryExpr;
import chocopy.common.astnodes.VarDef;
import chocopy.common.astnodes.WhileStmt;
import chocopy.reference.semantic.a;
import chocopy.reference.semantic.b;
import chocopy.reference.semantic.f;
import java.util.List;

class e
extends AbstractNodeAnalyzer<SymbolType> {
    private SymbolTable<SymbolType> b;
    private final f c;
    private SymbolType d;
    private final b e;
    private final Errors f;
    private final AbstractNodeAnalyzer<Boolean> g = new AbstractNodeAnalyzer<Boolean>(){

        public Boolean a(Identifier e2) {
            String varName = e2.name;
            if (e2.hasError()) {
                return true;
            }
            if (e.this.b.declares(varName)) {
                return true;
            }
            e.this.a(e2, "Cannot assign to variable that is not explicitly declared in this scope: %s", new Object[]{varName});
            return false;
        }

        public Boolean a(MemberExpr e2) {
            return true;
        }

        public Boolean a(IndexExpr e2) {
            SymbolType listType = e2.list.getInferredType();
            if (listType.isListType()) {
                return true;
            }
            e.this.a(e2, "`%s` is not a list type", new Object[]{listType});
            return false;
        }

        @Override
        public /* synthetic */ Object analyze(MemberExpr memberExpr) {
            return this.a(memberExpr);
        }

        @Override
        public /* synthetic */ Object analyze(IndexExpr indexExpr) {
            return this.a(indexExpr);
        }

        @Override
        public /* synthetic */ Object analyze(Identifier identifier) {
            return this.a(identifier);
        }
    };
    private BinaryExpr h;
    private SymbolType i;
    private SymbolType j;

    e(b declAnalyzer0, f typeHierarchy0, Errors errors0) {
        this.c = typeHierarchy0;
        this.e = declAnalyzer0;
        this.b = this.e.a();
        this.f = errors0;
    }

    private void a(Node node, String message, Object ... args) {
        assert (message != null);
        this.f.semError(node, message, args);
    }

    public SymbolType a(Program program) {
        for (Declaration decl : program.declarations) {
            decl.dispatch(this);
        }
        for (Stmt stmt : program.statements) {
            stmt.dispatch(this);
        }
        return null;
    }

    public SymbolType a(ExprStmt s) {
        s.expr.dispatch(this);
        return null;
    }

    public SymbolType a(IntegerLiteral i) {
        return i.setInferredType(SymbolType.INT_TYPE);
    }

    public SymbolType a(BinaryExpr e2) {
        SymbolType t1 = e2.left.dispatch(this);
        SymbolType t2 = e2.right.dispatch(this);
        this.h = e2;
        this.i = t1;
        this.j = t2;
        switch (e2.operator) {
            case "-": 
            case "*": 
            case "//": 
            case "%": {
                return this.a();
            }
            case "+": {
                return this.b();
            }
            case "<": 
            case ">": 
            case "<=": 
            case ">=": {
                return this.c();
            }
            case "and": 
            case "or": {
                return this.f();
            }
            case "==": 
            case "!=": {
                return this.d();
            }
            case "is": {
                return this.e();
            }
        }
        String msg = "No typechecking logic for binary operator: " + e2.operator;
        throw new UnsupportedOperationException(msg);
    }

    private SymbolType a() {
        if (ValueType.INT_TYPE.equals(this.i) && ValueType.INT_TYPE.equals(this.j)) {
            return this.h.setInferredType(ValueType.INT_TYPE);
        }
        this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
        return this.h.setInferredType(ValueType.INT_TYPE);
    }

    private SymbolType b() {
        if (ValueType.INT_TYPE.equals(this.i) || ValueType.STR_TYPE.equals(this.i) || this.i.isListType()) {
            if (this.i.equals(this.j)) {
                return this.h.setInferredType(this.i);
            }
            if (this.i.isListType() && this.j.isListType()) {
                ValueType elementType1 = this.i.elementType();
                ValueType elementType2 = this.j.elementType();
                SymbolType lub = this.c.c(elementType1, elementType2);
                return this.h.setInferredType(new ListValueType(lub));
            }
            this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
            if (ValueType.INT_TYPE.equals(this.i) || ValueType.INT_TYPE.equals(this.j)) {
                return this.h.setInferredType(ValueType.INT_TYPE);
            }
            return this.h.setInferredType(ValueType.OBJECT_TYPE);
        }
        this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
        return this.h.setInferredType(ValueType.OBJECT_TYPE);
    }

    private SymbolType c() {
        if (ValueType.INT_TYPE.equals(this.i) && ValueType.INT_TYPE.equals(this.j)) {
            return this.h.setInferredType(ValueType.BOOL_TYPE);
        }
        this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
        return this.h.setInferredType(ValueType.BOOL_TYPE);
    }

    private SymbolType d() {
        if (this.i.isSpecialType() || this.i.isListType()) {
            if (this.i.equals(this.j)) {
                return this.h.setInferredType(ValueType.BOOL_TYPE);
            }
            this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
            return this.h.setInferredType(ValueType.BOOL_TYPE);
        }
        this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
        return this.h.setInferredType(ValueType.BOOL_TYPE);
    }

    private SymbolType e() {
        if (this.i.isSpecialType() || this.j.isSpecialType()) {
            this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
            return this.h.setInferredType(ValueType.BOOL_TYPE);
        }
        return this.h.setInferredType(ValueType.BOOL_TYPE);
    }

    private SymbolType f() {
        if (ValueType.BOOL_TYPE.equals(this.i) && ValueType.BOOL_TYPE.equals(this.j)) {
            return this.h.setInferredType(ValueType.BOOL_TYPE);
        }
        this.a((Node)this.h, "Cannot apply operator `%s` on types `%s` and `%s`", this.h.operator, this.i, this.j);
        return this.h.setInferredType(ValueType.BOOL_TYPE);
    }

    public SymbolType a(Identifier id) {
        String varName = id.name;
        SymbolType varType = this.b.get(varName);
        if (varType != null && varType.isValueType()) {
            return id.setInferredType(varType);
        }
        this.a((Node)id, "Not a variable: " + varName, new Object[0]);
        return id.setInferredType(SymbolType.OBJECT_TYPE);
    }

    public SymbolType a(StringLiteral s) {
        return s.setInferredType(SymbolType.STR_TYPE);
    }

    public SymbolType a(BooleanLiteral s) {
        return s.setInferredType(SymbolType.BOOL_TYPE);
    }

    public SymbolType a(NoneLiteral e2) {
        return e2.setInferredType(ValueType.NONE_TYPE);
    }

    public SymbolType a(UnaryExpr e2) {
        String op = e2.operator;
        SymbolType t = e2.operand.dispatch(this);
        switch (op) {
            case "-": {
                if (ValueType.INT_TYPE.equals(t)) {
                    return e2.setInferredType(ValueType.INT_TYPE);
                }
                this.a((Node)e2, "Cannot apply operator `%s` on type `%s`", e2.operator, t);
                return e2.setInferredType(ValueType.INT_TYPE);
            }
            case "not": {
                if (ValueType.BOOL_TYPE.equals(t)) {
                    return e2.setInferredType(ValueType.BOOL_TYPE);
                }
                this.a((Node)e2, "Cannot apply operator `%s` on type `%s`", e2.operator, t);
                return e2.setInferredType(ValueType.BOOL_TYPE);
            }
        }
        String msg = "No typechecking logic for unary operator: " + e2.operator;
        throw new UnsupportedOperationException(msg);
    }

    private void a(Node node, SymbolType lhsType, Expr rhs, boolean traverse, String errorSuffix) {
        SymbolType rhsType;
        SymbolType symbolType = rhsType = traverse ? rhs.dispatch(this) : rhs.getInferredType();
        assert (rhsType != null);
        if (!this.c.b(rhsType, lhsType)) {
            this.a(node, "Expected type `%s`; got type `%s`%s", lhsType, rhsType, errorSuffix);
        }
    }

    private void a(Node node, SymbolType lhsType, Expr rhs) {
        this.a(node, lhsType, rhs, true, "");
    }

    private SymbolType a(Node node, Identifier id) {
        String varName = id.name;
        SymbolType varType = this.b.get(varName);
        if (varType != null && varType.isValueType()) {
            if (!this.b.declares(varName)) {
                this.a((Node)id, "Cannot assign to variable that is not explicitly declared in this scope: %s", varName);
            }
            return varType;
        }
        this.a(node, "Not a variable: " + varName, new Object[0]);
        return null;
    }

    public SymbolType a(VarDef d2) {
        String varName = d2.var.identifier.name;
        SymbolType varType = this.b.get(varName);
        if (varType != null && varType.isValueType()) {
            SymbolType lhsType = varType;
            this.a((Node)d2, lhsType, d2.value);
        } else assert (this.f.hasErrors()) : "Var type can only be missing if there were previous errors";
        return null;
    }

    public SymbolType a(AssignStmt s) {
        SymbolType rhsType;
        s.value.dispatch(this);
        for (Expr target : s.targets) {
            SymbolType lhsType = target.dispatch(this);
            if (lhsType != null) {
                this.a((Node)s, lhsType, s.value, false, "");
                target.dispatch(this.g);
                continue;
            }
            assert (this.f.hasErrors()) : "Var type can only be missing if there were previous errors";
        }
        if (!s.hasError() && s.targets.size() > 1 && (rhsType = s.value.getInferredType()).isListType() && SymbolType.NONE_TYPE.equals(rhsType.elementType())) {
            this.a((Node)s, "Right-hand side of multiple assignment may not be [<None>]", new Object[0]);
        }
        return null;
    }

    public SymbolType a(IndexExpr e2) {
        SymbolType listType = e2.list.dispatch(this);
        SymbolType indexType = e2.index.dispatch(this);
        if (ValueType.STR_TYPE.equals(listType)) {
            if (!ValueType.INT_TYPE.equals(indexType)) {
                this.a((Node)e2, "Index is of non-integer type `%s`", indexType);
            }
            return e2.setInferredType(ValueType.STR_TYPE);
        }
        if (listType.isListType()) {
            if (!ValueType.INT_TYPE.equals(indexType)) {
                this.a((Node)e2, "Index is of non-integer type `%s`", indexType);
            }
            return e2.setInferredType(listType.elementType());
        }
        this.a((Node)e2, "Cannot index into type `%s`", listType);
        return e2.setInferredType(ValueType.OBJECT_TYPE);
    }

    private SymbolType a(Node node, MemberExpr e2, boolean attribute) {
        String errorFormat;
        SymbolType objectType = e2.object.dispatch(this);
        String string = errorFormat = attribute ? "There is no attribute named `%s` in class `%s`" : "There is no method named `%s` in class `%s`";
        if (objectType instanceof ClassValueType) {
            ClassValueType classType = (ClassValueType)objectType;
            SymbolType symType = this.b.get(classType.className());
            assert (symType instanceof a) : "An expression can only be assigned a class-type if that class is defined";
            a classDefType = (a)symType;
            String memberName = e2.member.name;
            SymbolType memberType = classDefType.d.get(memberName);
            if (memberType == null) {
                this.a(node, errorFormat, memberName, classType);
                return null;
            }
            if (memberType.isFuncType()) {
                if (attribute) {
                    this.a(node, errorFormat, memberName, classType);
                    return null;
                }
                return memberType;
            }
            if (attribute) {
                return memberType;
            }
            this.a(node, errorFormat, memberName, classType);
            return null;
        }
        this.a(node, "Cannot access member of non-class type `%s`", objectType);
        return null;
    }

    public SymbolType a(MemberExpr e2) {
        SymbolType memberType = this.a((Node)e2, e2, true);
        if (memberType != null) {
            assert (memberType.isValueType()) : "getMemberType() returns non-null only if there are no errors";
            return e2.setInferredType(memberType);
        }
        return e2.setInferredType(ValueType.OBJECT_TYPE);
    }

    public SymbolType a(CallExpr e2) {
        for (Expr arg : e2.args) {
            arg.dispatch(this);
        }
        Identifier funcId = e2.function;
        String funcName = funcId.name;
        SymbolType symType = this.b.get(funcName);
        if (symType != null && symType instanceof FuncType) {
            FuncType func = (FuncType)symType;
            int numParams = func.parameters.size();
            ValueType retType = func.returnType;
            if (numParams != e2.args.size()) {
                this.a((Node)e2, "Expected %d arguments; got %d", numParams, e2.args.size());
            } else {
                for (int i = 0; i < numParams; ++i) {
                    ValueType paramType = func.getParamType(i);
                    Expr arg = e2.args.get(i);
                    this.a((Node)e2, paramType, arg, false, " in parameter " + i);
                }
            }
            funcId.setInferredType(func);
            return e2.setInferredType(retType);
        }
        if (symType != null && symType instanceof a) {
            a klass = (a)symType;
            symType = klass.d.get("__init__");
            assert (symType != null && symType instanceof FuncType) : "Every class must have an __init__ method";
            FuncType func = (FuncType)symType;
            assert (func.parameters.size() == 1) : "__init__ methods must take only the self argument";
            if (e2.args.size() > 0) {
                this.a((Node)e2, "Expected %d arguments; got %d", 0, e2.args.size());
            }
            ClassValueType classType = klass.b;
            return e2.setInferredType(classType);
        }
        this.a((Node)e2, "Not a function or class: " + e2.function.name, new Object[0]);
        return e2.setInferredType(ValueType.OBJECT_TYPE);
    }

    public SymbolType a(MethodCallExpr e2) {
        for (Expr arg : e2.args) {
            arg.dispatch(this);
        }
        SymbolType memberType = this.a((Node)e2, e2.method, false);
        if (memberType != null) {
            assert (memberType instanceof FuncType) : "getMemberType() returns non-null only if there are no errors";
            FuncType func = (FuncType)memberType;
            int numParams = func.parameters.size();
            ValueType retType = func.returnType;
            if (numParams != e2.args.size() + 1) {
                this.a((Node)e2, "Expected %d arguments; got %d", numParams - 1, e2.args.size());
            } else {
                assert (func.parameters.size() > 0) : "Methods must have at least one formal parameter";
                assert (this.c.b(e2.method.object.getInferredType(), func.getParamType(0))) : "If a method is defined in or inherited by a class type, then it must conform to the type of the first parameter";
                for (int i = 1; i < numParams; ++i) {
                    ValueType paramType = func.getParamType(i);
                    Expr arg = e2.args.get(i - 1);
                    this.a((Node)e2, paramType, arg, false, " in parameter " + i);
                }
            }
            e2.method.setInferredType(func);
            return e2.setInferredType(retType);
        }
        return e2.setInferredType(ValueType.OBJECT_TYPE);
    }

    public SymbolType a(ReturnStmt returnStmt) {
        Expr returnExpr = returnStmt.value;
        if (this.d == null) {
            this.a((Node)returnStmt, "Return statement cannot appear at the top level", new Object[0]);
        } else if (returnExpr != null) {
            this.a((Node)returnStmt, this.d, returnExpr);
        } else if (!this.c.b(SymbolType.NONE_TYPE, this.d)) {
            this.a((Node)returnStmt, "Expected type `%s`; got `None`", this.d);
        }
        return null;
    }

    public SymbolType a(FuncDef funcDef) {
        Identifier funcId = funcDef.name;
        String funcName = funcId.name;
        SymbolType symType = this.b.get(funcName);
        if (symType != null && symType instanceof FuncType) {
            FuncType funcDefType = (FuncType)symType;
            SymbolTable<SymbolType> oldSym = this.b;
            this.b = this.e.a(funcDef);
            SymbolType oldReturnType = this.d;
            this.d = funcDefType.returnType;
            for (Declaration decl : funcDef.declarations) {
                decl.dispatch(this);
            }
            for (Stmt stmt : funcDef.statements) {
                stmt.dispatch(this);
            }
            this.b = oldSym;
            this.d = oldReturnType;
        } else assert (this.f.hasErrors()) : "FuncDef type can only be missing if there were previous errors";
        return null;
    }

    public SymbolType a(ClassDef classDef) {
        Identifier classId = classDef.name;
        String className = classId.name;
        SymbolType symType = this.b.get(className);
        if (symType != null && symType instanceof a) {
            a classDefType = (a)symType;
            SymbolTable<SymbolType> oldSym = this.b;
            this.b = classDefType.d;
            assert (this.d == null) : "Return type environment should not be defined at the top level";
            for (Declaration decl : classDef.declarations) {
                decl.dispatch(this);
            }
            this.b = oldSym;
        } else assert (this.f.hasErrors()) : "ClassDef type can only be missing if there were previous errors";
        return null;
    }

    public SymbolType a(ListExpr e2) {
        List<Expr> elements = e2.elements;
        for (Expr elem : elements) {
            elem.dispatch(this);
        }
        if (elements.isEmpty()) {
            return e2.setInferredType(ValueType.EMPTY_TYPE);
        }
        SymbolType elementType = elements.get(0).getInferredType();
        for (int i = 1; i < elements.size(); ++i) {
            elementType = this.c.c(elementType, elements.get(i).getInferredType());
        }
        return e2.setInferredType(new ListValueType(elementType));
    }

    public SymbolType a(IfExpr ifExpr) {
        Expr cond = ifExpr.condition;
        SymbolType condType = cond.dispatch(this);
        if (!ValueType.BOOL_TYPE.equals(condType)) {
            this.a((Node)ifExpr, "Condition expression cannot be of type `%s`", condType);
        }
        ifExpr.thenExpr.dispatch(this);
        ifExpr.elseExpr.dispatch(this);
        SymbolType lub = this.c.c(ifExpr.thenExpr.getInferredType(), ifExpr.elseExpr.getInferredType());
        ifExpr.setInferredType(lub);
        return lub;
    }

    public SymbolType a(IfStmt ifStmt) {
        Expr cond = ifStmt.condition;
        SymbolType condType = cond.dispatch(this);
        if (!ValueType.BOOL_TYPE.equals(condType)) {
            this.a((Node)ifStmt, "Condition expression cannot be of type `%s`", condType);
        }
        for (Stmt s : ifStmt.thenBody) {
            s.dispatch(this);
        }
        for (Stmt s : ifStmt.elseBody) {
            s.dispatch(this);
        }
        return null;
    }

    public SymbolType a(WhileStmt whileStmt) {
        Expr cond = whileStmt.condition;
        SymbolType condType = cond.dispatch(this);
        if (!ValueType.BOOL_TYPE.equals(condType)) {
            this.a((Node)whileStmt, "Condition expression cannot be of type `%s`", condType);
        }
        for (Stmt s : whileStmt.body) {
            s.dispatch(this);
        }
        return null;
    }

    public SymbolType a(ForStmt forStmt) {
        SymbolType varType;
        SymbolType listType = forStmt.iterable.dispatch(this);
        if (listType.isListType()) {
            varType = this.a(forStmt, forStmt.identifier);
            if (varType != null) {
                ValueType elemType = listType.elementType();
                if (!this.c.b(elemType, varType)) {
                    this.a((Node)forStmt, "Expected type `%s`; got type `%s`", varType, elemType);
                } else {
                    forStmt.identifier.setInferredType(elemType);
                }
            }
        } else if (ValueType.STR_TYPE.equals(listType)) {
            varType = this.a(forStmt, forStmt.identifier);
            if (varType != null) {
                if (!this.c.b(ValueType.STR_TYPE, varType)) {
                    this.a((Node)forStmt, "Expected type `%s`; got type `%s`", varType, ValueType.STR_TYPE);
                } else {
                    forStmt.identifier.setInferredType(ValueType.STR_TYPE);
                }
            }
        } else {
            this.a((Node)forStmt, "Cannot iterate over value of type `%s`", listType);
        }
        for (Stmt s : forStmt.body) {
            s.dispatch(this);
        }
        return null;
    }

    @Override
    public /* synthetic */ Object analyze(WhileStmt whileStmt) {
        return this.a(whileStmt);
    }

    @Override
    public /* synthetic */ Object analyze(VarDef varDef) {
        return this.a(varDef);
    }

    @Override
    public /* synthetic */ Object analyze(UnaryExpr unaryExpr) {
        return this.a(unaryExpr);
    }

    @Override
    public /* synthetic */ Object analyze(StringLiteral stringLiteral) {
        return this.a(stringLiteral);
    }

    @Override
    public /* synthetic */ Object analyze(ReturnStmt returnStmt) {
        return this.a(returnStmt);
    }

    @Override
    public /* synthetic */ Object analyze(Program program) {
        return this.a(program);
    }

    @Override
    public /* synthetic */ Object analyze(NoneLiteral noneLiteral) {
        return this.a(noneLiteral);
    }

    @Override
    public /* synthetic */ Object analyze(MethodCallExpr methodCallExpr) {
        return this.a(methodCallExpr);
    }

    @Override
    public /* synthetic */ Object analyze(MemberExpr memberExpr) {
        return this.a(memberExpr);
    }

    @Override
    public /* synthetic */ Object analyze(ListExpr listExpr) {
        return this.a(listExpr);
    }

    @Override
    public /* synthetic */ Object analyze(IntegerLiteral integerLiteral) {
        return this.a(integerLiteral);
    }

    @Override
    public /* synthetic */ Object analyze(IndexExpr indexExpr) {
        return this.a(indexExpr);
    }

    @Override
    public /* synthetic */ Object analyze(IfStmt ifStmt) {
        return this.a(ifStmt);
    }

    @Override
    public /* synthetic */ Object analyze(IfExpr ifExpr) {
        return this.a(ifExpr);
    }

    @Override
    public /* synthetic */ Object analyze(Identifier identifier) {
        return this.a(identifier);
    }

    @Override
    public /* synthetic */ Object analyze(FuncDef funcDef) {
        return this.a(funcDef);
    }

    @Override
    public /* synthetic */ Object analyze(ForStmt forStmt) {
        return this.a(forStmt);
    }

    @Override
    public /* synthetic */ Object analyze(ExprStmt exprStmt) {
        return this.a(exprStmt);
    }

    @Override
    public /* synthetic */ Object analyze(ClassDef classDef) {
        return this.a(classDef);
    }

    @Override
    public /* synthetic */ Object analyze(CallExpr callExpr) {
        return this.a(callExpr);
    }

    @Override
    public /* synthetic */ Object analyze(BooleanLiteral booleanLiteral) {
        return this.a(booleanLiteral);
    }

    @Override
    public /* synthetic */ Object analyze(BinaryExpr binaryExpr) {
        return this.a(binaryExpr);
    }

    @Override
    public /* synthetic */ Object analyze(AssignStmt assignStmt) {
        return this.a(assignStmt);
    }
}

