/*
 * Decompiled with CFR 0.152.
 */
package chocopy.common.codegen;

import chocopy.common.analysis.SymbolTable;
import chocopy.common.analysis.types.SymbolType;
import chocopy.common.astnodes.Stmt;
import chocopy.common.codegen.Label;
import chocopy.common.codegen.StackVarInfo;
import chocopy.common.codegen.SymbolInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class FuncInfo
extends SymbolInfo {
    protected final String funcName;
    protected final int depth;
    protected final SymbolType returnType;
    protected final List<String> params = new ArrayList<String>();
    protected final List<StackVarInfo> locals = new ArrayList<StackVarInfo>();
    protected final List<Stmt> statements = new ArrayList<Stmt>();
    protected final SymbolTable<SymbolInfo> symbolTable;
    protected final Label codeLabel;
    protected final FuncInfo parentFuncInfo;
    protected Consumer<FuncInfo> emitter;

    public FuncInfo(String funcName, int depth, SymbolType returnType, SymbolTable<SymbolInfo> parentSymbolTable, FuncInfo parentFuncInfo, Consumer<FuncInfo> emitter) {
        this.funcName = funcName;
        this.codeLabel = new Label(String.format("$%s", funcName));
        this.depth = depth;
        this.returnType = returnType;
        this.symbolTable = new SymbolTable<SymbolInfo>(parentSymbolTable);
        this.parentFuncInfo = parentFuncInfo;
        this.emitter = emitter;
    }

    public void addParam(StackVarInfo paramInfo) {
        this.params.add(paramInfo.getVarName());
        this.symbolTable.put(paramInfo.getVarName(), paramInfo);
    }

    public void addLocal(StackVarInfo stackVarInfo) {
        this.locals.add(stackVarInfo);
        this.symbolTable.put(stackVarInfo.getVarName(), stackVarInfo);
    }

    public void addBody(List<Stmt> stmts) {
        this.statements.addAll(stmts);
    }

    public int getVarIndex(String name) {
        int idx = this.params.indexOf(name);
        if (idx >= 0) {
            return idx;
        }
        for (int i = 0; i < this.locals.size(); ++i) {
            if (!this.locals.get(i).getVarName().equals(name)) continue;
            return i + this.params.size() + 2;
        }
        String msg = String.format("%s is not a var defined in function %s", name, this.funcName);
        throw new IllegalArgumentException(msg);
    }

    public Label getCodeLabel() {
        return this.codeLabel;
    }

    public String getBaseName() {
        int rightmostDotIndex = this.funcName.lastIndexOf(46);
        if (rightmostDotIndex == -1) {
            return this.funcName;
        }
        return this.funcName.substring(rightmostDotIndex + 1);
    }

    public String getFuncName() {
        return this.funcName;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<String> getParams() {
        return this.params;
    }

    public SymbolType getReturnType() {
        return this.returnType;
    }

    public List<StackVarInfo> getLocals() {
        return this.locals;
    }

    public List<Stmt> getStatements() {
        return this.statements;
    }

    public SymbolTable<SymbolInfo> getSymbolTable() {
        return this.symbolTable;
    }

    public FuncInfo getParentFuncInfo() {
        return this.parentFuncInfo;
    }

    public void emitBody() {
        this.emitter.accept(this);
    }
}

