# CS267 Homework 0

## Bio

I'm a concurrent enrollment student, third year undergraduate majoring in Computer Science and Technology from HUST, China. 
I'm really interested in High Performance Computing and Distributed Computing, and willing to learn more about them. 
I'm new to the USA and this is my first year in UCB. In China, I participated some competition so I have some chance to
work on HPC optimizing problem with machine provided by HUST, so I would like to learn more about HPC.




<!--
dd## Application: NVIDIA Tesla V100 Architecture Design
Read http://people.eecs.berkeley.edu/~aditya/local_hw0/gaozhanxi_5444120_72472549_CS267%20hw0.pdf and I think analysing a specific application makes
problem much more difficult and less meaningful. So I read what I'll use: NVIDIA v100 document
 -->

## Examine an application problem: Single Image Super Resolution Challenge

Our team is currently working on Asia Supercomputing Competition 2019. My job is to optimize pytorch and python model code basing on profiling result
to make it more efficent on a multiple-machine GPU computing system.

The program will target on distributed-memory machine. The HPC consists of hundreds of nodes connected by InfiniBand, and every node has its own CPUs,
 RAM, HardDisks, and all of them share a 500TiB nfs harddisk grid. We own two nodes, 2x2 NVIDIA P100 GPUs, 32x2 CPU cores, 7168x2 GPU cores, 64GiBx2 RAM,
and other resources. We should run SR task as quicker as we can, consuming as less energy as we can, and getting as better result as we can.

This project bases on PyTorch framework, and PyTorch should be modified to speed up this project (we don't mind if other projects will be slowed down with our
modified pytorch. Our job is to optimize this project). We built PyTorch with modified gcc 7.3.0, cuda 9.2, cudnn 7.3.1, ubuntu 14.04 with linuxbrew. 

- The problem: copy-paste from ASC19 problem document.

Our team should design an algorithm using SOTA strategies like deep
learning to do the 4x SR upscaling for images which were down-sampled with a bicubic kernel. For
instance, the resolution of a 400x600 image after 4x upscaling is 1600x2400. The evaluation will
be done in a perceptual-quality aware manner. The perceptual index (PI) defined in pirm2018 [4]
will be used to calculate the quality of the reconstructed high-resolution images. Lower PI means
higher quality of the reconstructed image. Ma and NIQE are two no-reference image quality
measures.

- Existing implementation to solve SR problem

Because our program is still under working, I'll analyse others' model and code as HW0.

SRGAN is an outstanding model for SR task, and pytorch and tensorlayer have implemented it. The model
graph is attached below:

![image1](https://recolic.net/tmp/srg1.png)

<!--![image2](https://recolic.net/tmp/srg2.png)-->

To have it parallelized, I may choose between model parallelism and data parallelism. Since I only have
2 nodes, so I prefer a centralized parameter server, which won't suffer from communication bottleneck.
PyTorch already contains necessary CUDA code to make full use of computing power of gpu, so communication
is the problem.
Both generator and discriminator should be trained. To make it scale well with more than 2 machines, I'll try 
distributed training methods, for example, Async SGD, with or without compressed parameters.


## References

[1] Large Scale Distributed Neural Network Training Through Online Distillation
Anil- Rohan- Pereyra- Gabriel- Passos- Alexandre- Robert- Dahl-George E.- Hinton-Geoffrey E. - https://arxiv.org/abs/1804.03235

[2] Introduction To Distributed Training Of Neural Networks
Skymind - https://blog.skymind.ai/distributed-deep-learning-part-1-an-introduction-to-distributed-training-of-neural-networks/

