/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs2018;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Probe2
extends InstanceFactory {
    public static String text;

    public Probe2() {
        super("Mips Probe");
        this.setOffsetBounds(Bounds.create((int)-60, (int)-20, (int)120, (int)40));
        this.setPorts(new Port[]{new Port(-60, 0, "input", 32)});
    }

    public void propagate(InstanceState state) {
        int x = state.getPort(0).toIntValue();
        int op1 = x >> 26;
        int rs = (x & 0x3E00000) >> 21;
        int rt = (x & 0x1F0000) >> 16;
        int rd = (x & 0xF800) >> 11;
        int sa = (x & 0x3E0) >> 6;
        int im = x & 0xFFFF;
        int op2 = x & 0x3F;
        block0 : switch (op1) {
            case 8: {
                text = "addi " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 9: {
                text = "addiu " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 10: {
                text = "slti " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 11: {
                text = "sltiu " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 12: {
                text = "andi " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 13: {
                text = "ori " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 14: {
                text = "xori " + this.reg(rt) + "," + this.reg(rs) + "," + im;
                break;
            }
            case 35: {
                text = "lw " + this.reg(rt) + "," + im + "(" + this.reg(rs) + ")";
                break;
            }
            case 43: {
                text = "sw " + this.reg(rt) + "," + im + "(" + this.reg(rs) + ")";
                break;
            }
            case 4: {
                text = "beq " + this.reg(rs) + "," + this.reg(rt) + "," + im;
                break;
            }
            case 5: {
                text = "bne " + this.reg(rs) + "," + this.reg(rt) + "," + im;
                break;
            }
            case 2: {
                text = "j";
                break;
            }
            case 3: {
                text = "jal";
                break;
            }
            case 0: {
                switch (op2) {
                    case 32: {
                        text = "add " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 33: {
                        text = "addu " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 34: {
                        text = "sub " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 35: {
                        text = "subu " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 36: {
                        text = "and " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 37: {
                        text = "or " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 38: {
                        text = "xor " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 39: {
                        text = "nor " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 42: {
                        text = "slt " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 43: {
                        text = "sltu " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 10: {
                        text = "movz " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 11: {
                        text = "movn " + this.reg(rd) + "," + this.reg(rs) + "," + this.reg(rt);
                        break block0;
                    }
                    case 8: {
                        text = "jr " + this.reg(rs);
                        break block0;
                    }
                    case 12: {
                        text = "syscall";
                        break block0;
                    }
                    case 0: {
                        text = "sll " + this.reg(rd) + "," + this.reg(rt) + "," + sa;
                        break block0;
                    }
                    case 2: {
                        text = "srl " + this.reg(rd) + "," + this.reg(rt) + "," + sa;
                        break block0;
                    }
                    case 3: {
                        text = "sra " + this.reg(rd) + "," + this.reg(rt) + "," + sa;
                        break block0;
                    }
                    case 4: {
                        text = "sllv " + this.reg(rd) + "," + this.reg(rt) + "," + this.reg(rs);
                        break block0;
                    }
                    case 6: {
                        text = "srlv " + this.reg(rd) + "," + this.reg(rt) + "," + this.reg(rs);
                        break block0;
                    }
                    case 7: {
                        text = "srav " + this.reg(rd) + "," + this.reg(rt) + "," + this.reg(rs);
                        break block0;
                    }
                }
                text = " ";
                break;
            }
            default: {
                text = " ";
            }
        }
    }

    public String reg(int num) {
        String text2 = null;
        switch (num) {
            case 0: {
                text2 = "$zero";
                break;
            }
            case 1: {
                text2 = "$at";
                break;
            }
            case 2: {
                text2 = "$v0";
                break;
            }
            case 3: {
                text2 = "$v1";
                break;
            }
            case 4: {
                text2 = "$a0";
                break;
            }
            case 5: {
                text2 = "$a1";
                break;
            }
            case 6: {
                text2 = "$a2";
                break;
            }
            case 7: {
                text2 = "$a3";
                break;
            }
            case 8: {
                text2 = "$t0";
                break;
            }
            case 9: {
                text2 = "$t1";
                break;
            }
            case 10: {
                text2 = "$t2";
                break;
            }
            case 11: {
                text2 = "$t3";
                break;
            }
            case 12: {
                text2 = "$t4";
                break;
            }
            case 13: {
                text2 = "$t5";
                break;
            }
            case 14: {
                text2 = "$t6";
                break;
            }
            case 15: {
                text2 = "$t7";
                break;
            }
            case 16: {
                text2 = "$s0";
                break;
            }
            case 17: {
                text2 = "$s1";
                break;
            }
            case 18: {
                text2 = "$s2";
                break;
            }
            case 19: {
                text2 = "$s3";
                break;
            }
            case 20: {
                text2 = "$s4";
                break;
            }
            case 21: {
                text2 = "$s5";
                break;
            }
            case 22: {
                text2 = "$s6";
                break;
            }
            case 23: {
                text2 = "$s7";
                break;
            }
            case 24: {
                text2 = "$t8";
                break;
            }
            case 25: {
                text2 = "$t9";
                break;
            }
            case 26: {
                text2 = "$k0";
                break;
            }
            case 27: {
                text2 = "$k1";
                break;
            }
            case 28: {
                text2 = "$gp";
                break;
            }
            case 29: {
                text2 = "$sp";
                break;
            }
            case 30: {
                text2 = "$fp";
                break;
            }
            case 31: {
                text2 = "$ra";
            }
        }
        return text2;
    }

    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bounds = painter.getBounds();
        int x0 = bounds.getX();
        int x1 = x0 + bounds.getWidth();
        int y0 = bounds.getY();
        int y1 = y0 + bounds.getHeight();
        int[] xp = new int[]{x0, x1, x1, x0};
        int[] yp = new int[]{y0, y0, y1, y1};
        GraphicsUtil.switchToWidth((Graphics)painter.getGraphics(), (int)2);
        painter.getGraphics().drawPolygon(xp, yp, 4);
        painter.drawPort(0, "", Direction.EAST);
        GraphicsUtil.drawCenteredText((Graphics)g, (String)text, (int)(bounds.getX() + bounds.getWidth() / 2), (int)(bounds.getY() + bounds.getHeight() / 2));
    }

    public void paintIcon(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.BLACK);
        g.drawOval(6, 6, 9, 9);
    }
}

