/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.util.EventSourceWeakSupport;
import edu.cornell.cs3410.MemContentsSub;
import java.util.Arrays;

class MemContents
implements Cloneable,
HexModel {
    private static final int PAGE_SIZE_BITS = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private EventSourceWeakSupport<HexModelListener> listeners = null;
    private int width;
    private int addrBits;
    private int mask;
    private MemContentsSub.ContentsInterface[] pages;

    static MemContents create(int addrBits, int width) {
        return new MemContents(addrBits, width);
    }

    private MemContents(int addrBits, int width) {
        this.setDimensions(addrBits, width);
    }

    public void addHexModelListener(HexModelListener l) {
        if (this.listeners == null) {
            this.listeners = new EventSourceWeakSupport();
        }
        this.listeners.add((Object)l);
    }

    public void removeHexModelListener(HexModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.add((Object)l);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private void fireMetainfoChanged() {
        if (this.listeners == null) {
            return;
        }
        boolean found = false;
        for (HexModelListener l : this.listeners) {
            found = true;
            l.metainfoChanged((HexModel)this);
        }
        if (!found) {
            this.listeners = null;
        }
    }

    private void fireBytesChanged(long start, long numBytes, int[] oldValues) {
        if (this.listeners == null) {
            return;
        }
        boolean found = false;
        for (HexModelListener l : this.listeners) {
            found = true;
            l.bytesChanged((HexModel)this, start, numBytes, oldValues);
        }
        if (!found) {
            this.listeners = null;
        }
    }

    public MemContents clone() {
        try {
            MemContents ret = (MemContents)super.clone();
            ret.listeners = null;
            ret.pages = new MemContentsSub.ContentsInterface[this.pages.length];
            for (int i = 0; i < ret.pages.length; ++i) {
                if (this.pages[i] == null) continue;
                ret.pages[i] = this.pages[i].clone();
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    public int getLogLength() {
        return this.addrBits;
    }

    public int getWidth() {
        return this.width;
    }

    public int get(long addr) {
        int page = (int)(addr >>> 12);
        int offs = (int)(addr & 0xFFFL);
        if (page < 0 || page >= this.pages.length || this.pages[page] == null) {
            return 0;
        }
        return this.pages[page].get(offs) & this.mask;
    }

    public boolean isClear() {
        for (int i = 0; i < this.pages.length; ++i) {
            MemContentsSub.ContentsInterface page = this.pages[i];
            if (page == null) continue;
            for (int j = page.getLength() - 1; j >= 0; --j) {
                if (page.get(j) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public void set(long addr, int value) {
        int val;
        int page = (int)(addr >>> 12);
        int offs = (int)(addr & 0xFFFL);
        int old = this.pages[page] == null ? 0 : this.pages[page].get(offs) & this.mask;
        if (old != (val = value & this.mask)) {
            if (this.pages[page] == null) {
                this.pages[page] = MemContentsSub.createContents(4096, this.width);
            }
            this.pages[page].set(offs, val);
            this.fireBytesChanged(addr, 1L, new int[]{old});
        }
    }

    public void set(long start, int[] values) {
        if (values.length == 0) {
            return;
        }
        int pageStart = (int)(start >>> 12);
        int startOffs = (int)(start & 0xFFFL);
        int pageEnd = (int)(start + (long)values.length - 1L >>> 12);
        int endOffs = (int)(start + (long)values.length - 1L & 0xFFFL);
        if (pageStart == pageEnd) {
            this.ensurePage(pageStart);
            MemContentsSub.ContentsInterface page = this.pages[pageStart];
            if (!page.matches(values, startOffs, this.mask)) {
                int[] oldValues = page.get(startOffs, values.length);
                page.load(startOffs, values, this.mask);
                if (page.isClear()) {
                    this.pages[pageStart] = null;
                }
                this.fireBytesChanged(start, values.length, oldValues);
            }
        } else {
            int[] vals;
            int nextOffs;
            if (startOffs == 0) {
                --pageStart;
                nextOffs = 0;
            } else {
                this.ensurePage(pageStart);
                vals = new int[4096 - startOffs];
                System.arraycopy(values, 0, vals, 0, vals.length);
                MemContentsSub.ContentsInterface page = this.pages[pageStart];
                if (!page.matches(vals, startOffs, this.mask)) {
                    int[] oldValues = page.get(startOffs, vals.length);
                    page.load(startOffs, vals, this.mask);
                    if (page.isClear()) {
                        this.pages[pageStart] = null;
                    }
                    this.fireBytesChanged(start, 4096 - pageStart, oldValues);
                }
                nextOffs = vals.length;
            }
            vals = new int[4096];
            int offs = nextOffs;
            int i = pageStart + 1;
            while (i < pageEnd) {
                MemContentsSub.ContentsInterface page = this.pages[i];
                if (page == null) {
                    boolean allZeroes = true;
                    for (int j = 0; j < 4096; ++j) {
                        if ((values[offs + j] & this.mask) == 0) continue;
                        allZeroes = false;
                        break;
                    }
                    if (!allZeroes) {
                        this.pages[i] = page = MemContentsSub.createContents(4096, this.width);
                    }
                }
                if (page != null) {
                    System.arraycopy(values, offs, vals, 0, 4096);
                    if (!page.matches(vals, startOffs, this.mask)) {
                        int[] oldValues = page.get(0, 4096);
                        page.load(0, vals, this.mask);
                        if (page.isClear()) {
                            this.pages[i] = null;
                        }
                        this.fireBytesChanged((long)i << 12, 4096L, oldValues);
                    }
                }
                ++i;
                offs += 4096;
            }
            if (endOffs >= 0) {
                this.ensurePage(pageEnd);
                vals = new int[endOffs + 1];
                System.arraycopy(values, offs, vals, 0, endOffs + 1);
                MemContentsSub.ContentsInterface page = this.pages[pageEnd];
                if (!page.matches(vals, startOffs, this.mask)) {
                    int[] oldValues = page.get(0, endOffs + 1);
                    page.load(0, vals, this.mask);
                    if (page.isClear()) {
                        this.pages[pageEnd] = null;
                    }
                    this.fireBytesChanged((long)pageEnd << 12, endOffs + 1, oldValues);
                }
            }
        }
    }

    public void fill(long start, long len, int value) {
        if (len == 0L) {
            return;
        }
        int pageStart = (int)(start >>> 12);
        int startOffs = (int)(start & 0xFFFL);
        int pageEnd = (int)(start + len - 1L >>> 12);
        int endOffs = (int)(start + len - 1L & 0xFFFL);
        value &= this.mask;
        if (pageStart == pageEnd) {
            this.ensurePage(pageStart);
            int[] vals = new int[(int)len];
            Arrays.fill(vals, value);
            MemContentsSub.ContentsInterface page = this.pages[pageStart];
            if (!page.matches(vals, startOffs, this.mask)) {
                int[] oldValues = page.get(startOffs, (int)len);
                page.load(startOffs, vals, this.mask);
                if (value == 0 && page.isClear()) {
                    this.pages[pageStart] = null;
                }
                this.fireBytesChanged(start, len, oldValues);
            }
        } else {
            int[] oldValues;
            int[] vals;
            if (startOffs == 0) {
                --pageStart;
            } else if (value != 0 || this.pages[pageStart] != null) {
                this.ensurePage(pageStart);
                vals = new int[4096 - startOffs];
                Arrays.fill(vals, value);
                MemContentsSub.ContentsInterface page = this.pages[pageStart];
                if (!page.matches(vals, startOffs, this.mask)) {
                    oldValues = page.get(startOffs, vals.length);
                    page.load(startOffs, vals, this.mask);
                    if (value == 0 && page.isClear()) {
                        this.pages[pageStart] = null;
                    }
                    this.fireBytesChanged(start, 4096 - pageStart, oldValues);
                }
            }
            if (value == 0) {
                for (int i = pageStart + 1; i < pageEnd; ++i) {
                    if (this.pages[i] == null) continue;
                    this.clearPage(i);
                }
            } else {
                vals = new int[4096];
                Arrays.fill(vals, value);
                for (int i = pageStart + 1; i < pageEnd; ++i) {
                    this.ensurePage(i);
                    MemContentsSub.ContentsInterface page = this.pages[i];
                    if (page.matches(vals, 0, this.mask)) continue;
                    int[] oldValues2 = page.get(0, 4096);
                    page.load(0, vals, this.mask);
                    this.fireBytesChanged((long)i << 12, 4096L, oldValues2);
                }
            }
            if (endOffs >= 0) {
                MemContentsSub.ContentsInterface page = this.pages[pageEnd];
                if (value != 0 || page != null) {
                    this.ensurePage(pageEnd);
                    int[] vals2 = new int[endOffs + 1];
                    Arrays.fill(vals2, value);
                    if (!page.matches(vals2, 0, this.mask)) {
                        oldValues = page.get(0, endOffs + 1);
                        page.load(0, vals2, this.mask);
                        if (value == 0 && page.isClear()) {
                            this.pages[pageEnd] = null;
                        }
                        this.fireBytesChanged((long)pageEnd << 12, endOffs + 1, oldValues);
                    }
                }
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.pages.length; ++i) {
            if (this.pages[i] == null || this.pages[i] == null) continue;
            this.clearPage(i);
        }
    }

    private void clearPage(int index) {
        MemContentsSub.ContentsInterface page = this.pages[index];
        int[] oldValues = new int[page.getLength()];
        boolean changed = false;
        for (int j = 0; j < oldValues.length; ++j) {
            int val;
            oldValues[j] = val = page.get(j) & this.mask;
            if (val == 0) continue;
            changed = true;
        }
        if (changed) {
            this.pages[index] = null;
            this.fireBytesChanged(index << 12, oldValues.length, oldValues);
        }
    }

    public void setDimensions(int addrBits, int width) {
        int pageLength;
        int pageCount;
        if (addrBits == this.addrBits && width == this.width) {
            return;
        }
        this.addrBits = addrBits;
        this.width = width;
        this.mask = width == 32 ? -1 : (1 << width) - 1;
        MemContentsSub.ContentsInterface[] oldPages = this.pages;
        if (addrBits < 12) {
            pageCount = 1;
            pageLength = 1 << addrBits;
        } else {
            pageCount = 1 << addrBits - 12;
            pageLength = 4096;
        }
        this.pages = new MemContentsSub.ContentsInterface[pageCount];
        if (oldPages != null) {
            int n = Math.min(oldPages.length, this.pages.length);
            for (int i = 0; i < n; ++i) {
                if (oldPages[i] == null) continue;
                this.pages[i] = MemContentsSub.createContents(pageLength, width);
                int m = Math.max(oldPages[i].getLength(), pageLength);
                for (int j = 0; j < m; ++j) {
                    this.pages[i].set(j, oldPages[i].get(j));
                }
            }
        }
        if (pageCount == 0 && this.pages[0] == null) {
            this.pages[0] = MemContentsSub.createContents(pageLength, width);
        }
        this.fireMetainfoChanged();
    }

    public long getFirstOffset() {
        return 0L;
    }

    public long getLastOffset() {
        return (1L << this.addrBits) - 1L;
    }

    public int getValueWidth() {
        return this.width;
    }

    private void ensurePage(int index) {
        if (this.pages[index] == null) {
            this.pages[index] = MemContentsSub.createContents(4096, this.width);
        }
    }
}

