/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import edu.cornell.cs3410.MemState;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class MemPoker
extends InstancePoker {
    private MemPoker sub;

    public boolean init(InstanceState state, MouseEvent event) {
        Bounds bds = state.getInstance().getBounds();
        MemState data = (MemState)state.getData();
        long addr = data.getAddressAt(event.getX() - bds.getX(), event.getY() - bds.getY());
        this.sub = addr < 0L ? new AddrPoker() : new DataPoker(state, data, addr);
        return true;
    }

    public Bounds getBounds(InstancePainter state) {
        return this.sub.getBounds(state);
    }

    public void paint(InstancePainter painter) {
        this.sub.paint(painter);
    }

    public void keyTyped(InstanceState state, KeyEvent e) {
        this.sub.keyTyped(state, e);
    }

    private static class AddrPoker
    extends MemPoker {
        private AddrPoker() {
        }

        public Bounds getBounds(InstancePainter painter) {
            MemState data = (MemState)painter.getData();
            return data.getBounds(-1L, painter.getBounds());
        }

        public void paint(InstancePainter painter) {
            Bounds bds = this.getBounds(painter);
            Graphics g = painter.getGraphics();
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }

        public void keyTyped(InstanceState state, KeyEvent e) {
            char c = e.getKeyChar();
            int val = Character.digit(e.getKeyChar(), 16);
            MemState data = (MemState)state.getData();
            if (val >= 0) {
                long newScroll = data.getScroll() * 16L + (long)val & data.getLastAddress();
                data.setScroll(newScroll);
            } else if (c == ' ') {
                data.setScroll(data.getScroll() + (long)((data.getRows() - 1) * data.getColumns()));
            } else if (c == '\r' || c == '\n') {
                data.setScroll(data.getScroll() + (long)data.getColumns());
            } else if (c == '\b' || c == '\u007f') {
                data.setScroll(data.getScroll() - (long)data.getColumns());
            }
        }
    }

    private static class DataPoker
    extends MemPoker {
        int initValue;
        int curValue;

        private DataPoker(InstanceState state, MemState data, long addr) {
            data.setCursor(addr);
            this.curValue = this.initValue = data.getContents().get(data.getCursor());
            AttributeSet attrs = state.getInstance().getAttributeSet();
        }

        public Bounds getBounds(InstancePainter painter) {
            MemState data = (MemState)painter.getData();
            Bounds inBounds = painter.getInstance().getBounds();
            return data.getBounds(data.getCursor(), inBounds);
        }

        public void paint(InstancePainter painter) {
            Bounds bds = this.getBounds(painter);
            Graphics g = painter.getGraphics();
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }

        public void stopEditing(InstanceState state) {
            MemState data = (MemState)state.getData();
            data.setCursor(-1L);
        }

        public void keyTyped(InstanceState state, KeyEvent e) {
            char c = e.getKeyChar();
            int val = Character.digit(e.getKeyChar(), 16);
            MemState data = (MemState)state.getData();
            if (val >= 0) {
                this.curValue = this.curValue * 16 + val;
                data.getContents().set(data.getCursor(), this.curValue);
                state.fireInvalidated();
            } else if (c == ' ' || c == '\t') {
                this.moveTo(data, data.getCursor() + 1L);
            } else if (c == '\r' || c == '\n') {
                this.moveTo(data, data.getCursor() + (long)data.getColumns());
            } else if (c == '\b' || c == '\u007f') {
                this.moveTo(data, data.getCursor() - 1L);
            }
        }

        private void moveTo(MemState data, long addr) {
            if (data.isValidAddr(addr)) {
                data.setCursor(addr);
                data.scrollToShow(addr);
                this.curValue = this.initValue = data.getContents().get(addr);
            }
        }
    }
}

