/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import edu.cornell.cs3410.RegisterUtils;

public class RegisterData
implements InstanceData,
Cloneable {
    private Value lastClock;
    Value[] regs;

    public static RegisterData get(InstanceState state) {
        RegisterData ret = (RegisterData)state.getData();
        if (ret == null) {
            ret = new RegisterData(null, new Value[32]);
            state.setData((InstanceData)ret);
        }
        return ret;
    }

    private RegisterData(Value lastClock, Value[] regs) {
        this.lastClock = lastClock;
        this.regs = regs;
        this.regs[0] = RegisterUtils.zero;
        this.reset(RegisterUtils.zero);
    }

    public void reset(Value val) {
        for (int i = 1; i < 32; ++i) {
            this.regs[i] = val;
        }
    }

    public RegisterData clone() {
        try {
            return (RegisterData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean updateClock(Value newClock, Object trigger) {
        Value oldClock = this.lastClock;
        this.lastClock = newClock;
        if (trigger == null || trigger == StdAttr.TRIG_RISING) {
            return oldClock == Value.FALSE && newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_FALLING) {
            return oldClock == Value.TRUE && newClock == Value.FALSE;
        }
        if (trigger == StdAttr.TRIG_HIGH) {
            return newClock == Value.TRUE;
        }
        if (trigger == StdAttr.TRIG_LOW) {
            return newClock == Value.FALSE;
        }
        return oldClock == Value.FALSE && newClock == Value.TRUE;
    }
}

