/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs3410;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import edu.cornell.cs3410.RegisterData;
import edu.cornell.cs3410.RegisterPoker;
import edu.cornell.cs3410.RegisterUtils;
import edu.cornell.cs3410.SimpleStringGetter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class RegisterFile32
extends InstanceFactory {
    private static final Attribute[] ATTRIBUTES = new Attribute[]{StdAttr.TRIGGER};

    RegisterFile32() {
        super("RegisterFile", (StringGetter)new SimpleStringGetter("Register File"));
        this.setAttributes(new Attribute[]{StdAttr.TRIGGER}, new AttributeOption[]{StdAttr.TRIG_RISING});
        this.setOffsetBounds(Bounds.create((int)-160, (int)-90, (int)160, (int)180));
        int left = -160;
        int right = 0;
        int top = -90;
        int bottom = 90;
        this.setPorts(new Port[]{new Port(left, -10, "input", 32), new Port(right, top + 40, "output", 32), new Port(right, bottom - 40, "output", 32), new Port(left + 80 - 40, bottom, "input", 1), new Port(left, bottom - 10, "input", 1), new Port(left + 80 - 10, bottom, "input", 5), new Port(left + 80 + 30, bottom, "input", 5), new Port(left + 80 + 50, bottom, "input", 5)});
        this.setInstancePoker(RegisterPoker.class);
    }

    public void propagate(InstanceState state) {
        Value v1;
        RegisterData data = RegisterData.get(state);
        AttributeOption triggerType = (AttributeOption)state.getAttributeValue(StdAttr.TRIGGER);
        if (data.updateClock(RegisterUtils.val(state, 4), triggerType) && RegisterUtils.val(state, 3) != Value.FALSE) {
            int a = RegisterUtils.addr(state, 5);
            Value v = RegisterUtils.val(state, 0);
            if (a < 0) {
                data.reset(RegisterUtils.zzzz);
            } else if (a != 0) {
                if (a < 32) {
                    data.regs[a] = v;
                } else {
                    throw new IllegalArgumentException("Write address invalid: Please email kwalsh@cs and tell him!");
                }
            }
        }
        int a1 = RegisterUtils.addr(state, 6);
        int a2 = RegisterUtils.addr(state, 7);
        if (a1 >= 32 || a2 >= 32) {
            throw new IllegalArgumentException("Read address invalid: Please email kwalsh@cs and tell him!");
        }
        Value value = a1 < 0 ? RegisterUtils.zzzz : (v1 = a1 < 32 ? data.regs[a1] : RegisterUtils.xxxx);
        Value v2 = a2 < 0 ? RegisterUtils.zzzz : (a2 < 32 ? data.regs[a2] : RegisterUtils.xxxx);
        state.setPort(1, v1, 9);
        state.setPort(2, v2, 9);
    }

    public void paintInstance(InstancePainter painter) {
        int i;
        painter.drawRectangle(painter.getBounds(), "");
        painter.drawClock(4, Direction.EAST);
        painter.drawPort(5);
        painter.drawPort(0);
        painter.drawPort(3);
        painter.drawPort(6);
        painter.drawPort(1);
        painter.drawPort(7);
        painter.drawPort(2);
        Graphics g = painter.getGraphics();
        Bounds bounds = painter.getBounds();
        Font font = g.getFont().deriveFont(9.0f);
        int left = bounds.getX();
        int right = bounds.getX() + 160;
        int top = bounds.getY();
        int bottom = bounds.getY() + 180;
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"W", (int)(left + 2), (int)(top + 90 - 10), (int)-1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"A", (int)(right - 2), (int)(top + 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (Font)font, (String)"B", (int)(right - 2), (int)(bottom - 40), (int)1, (int)0);
        GraphicsUtil.drawText((Graphics)g, (String)"WE", (int)(left + 80 - 40), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rW", (int)(left + 80 - 10), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rA", (int)(left + 80 + 30), (int)(bottom - 1), (int)0, (int)2);
        GraphicsUtil.drawText((Graphics)g, (String)"rB", (int)(left + 80 + 50), (int)(bottom - 1), (int)0, (int)2);
        for (i = 0; i < 32; ++i) {
            RegisterUtils.drawBox(g, bounds, Color.GRAY, i);
        }
        for (i = 0; i < 32; ++i) {
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)("$" + i), (int)(bounds.getX() + RegisterUtils.boxX(i) - 1), (int)(bounds.getY() + RegisterUtils.boxY(i) + 4), (int)1, (int)0);
        }
        if (!painter.getShowState()) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(bounds.getX() + RegisterUtils.boxX(0) + 1, bounds.getY() + RegisterUtils.boxY(0) + 1, 49, 9);
        g.setColor(Color.BLACK);
        RegisterData data = RegisterData.get((InstanceState)painter);
        for (int i2 = 0; i2 < 32; ++i2) {
            int v = data.regs[i2].toIntValue();
            String s = data.regs[i2].isFullyDefined() ? StringUtil.toHexString((int)RegisterUtils.WIDTH.getWidth(), (int)v) : "?";
            GraphicsUtil.drawText((Graphics)g, (Font)font, (String)s, (int)(bounds.getX() + RegisterUtils.boxX(i2) + 25), (int)(bounds.getY() + RegisterUtils.boxY(i2) + 4), (int)0, (int)0);
        }
    }
}

