#ifndef _HUST___PARSER_HPP
#define _HUST___PARSER_HPP 1

#include <reflected_impl.hpp>
#include <list>
#include <string>
#include <iomanip>

#include <rlib/stdio.hpp>
#include <rlib/terminal.hpp>
using namespace rlib::terminal;

class parser {
private:
    static void help_msg() {
        std::string msg = R"_STR_(
rfaketerm 0.2 HUST_xxxx special edition

>>> Usage: <Command> [args ...]

>>> Command List:

CommandName [Arguments ...] -> ReturnValue # Instructions

help -> null # Show this message
exit -> null # exit politely
Select [int i] -> null # Select which btree to use (Select 0 by default, index starts from zero)
List -> null # List how many btree is working currently

InitBiTree -> null
DestroyBiTree -> null
CreateBiTree -> null
ClearBiTree -> null
BiTreeEmpty -> bool
BiTreeDepth -> int
Root -> NodeLanguage
Value [NodeLanguage n] -> data_t
Assign [NodeLanguage n, data_t val] -> null
Parent [NodeLanguage n] -> NodeLanguage
LeftChild [NodeLanguage n] -> NodeLanguage
RightChild [NodeLanguage n] -> NodeLanguage
LeftSibling [NodeLanguage n] -> NodeLanguage
RightSibling [NodeLanguage n] -> NodeLanguage
InsertChild [NodeLanguage n, int toInsert, int LR] -> null # toInsert is index of btree to insert, start from zero, in `List`
DeleteChild [NodeLanguage n, int LR] -> null
PreOrderTraverse -> null
InOrderTraverse -> null
PostOrderTraverse -> null
LevelOrderTraverse -> null

>>> What's NodeLanguage?

NodeLanguage is a string language, with which you can appoint a node in a tree easily and quickly.
Example: assume you have a tree like this now,

         A
        / \
       B   C
      / \   \
     F  G    H
       /    /
      J    X

Then you can use NodeLanguage to represent every node:
    A = ""
    B = "L"
    C = "R"
    F = "LL"
    G = "LR"
    H = "RR"
    J = "LRL"
    X = "RRL"

Every 'L' and 'R' represents a step, and you can reach the node step by step.
You can also appoint a not existing node, sothat you can insert a node here. But all node in the path must exists, here're examples:

Assign(Y, "RRLR"); //Good
Assign(D, "RLL"); //Bad, "RL" not exist
Assign(M, "L"); //Valid, B is erased and M is assigned
Assign(N , "   LR L  L "); //Valid, extra spaces are allowed in NodeLanguage

So you can build a tree quickly in my terminal like this:
rfaketerm ~ Assign  1
rfaketerm ~ Assign L 3
rfaketerm ~ Assign R 22
rfaketerm ~ Assign LR 11
)_STR_";
        rlib::println(msg);
    }
public:
    static void parse(const std::vector<std::string> &to_parse) {
        if(to_parse.empty())
            return;
        rlib::print(std::boolalpha);

#define AREA_BEGIN if(to_parse.begin()->empty()) {}
#define IFCMD(str) else if(*to_parse.begin() == str)
#define AREA_END else 

#define WANT_ARG(n) if(to_parse.size() != n+1) {throw std::runtime_error(rlib::format_string("{} arguments wanted but {} provided.", n, to_parse.size()-1));}
#define STRING_ARG(n) to_parse[n]
#define SIZE_ARG(n) std::stoul(to_parse[n])
#define INT_ARG(n) std::stoi(to_parse[n])
#define HAVE_RETURN_VALUE auto ret =
#define PRINT_RETURN_VALUE rlib::println(ret);

    AREA_BEGIN
//Code generated by ccgen.py below. Do not edit them by hand.
//__ccgen_debug__: `ret name(args)` is `null Select(size_t i)`
    IFCMD("Select") {
        WANT_ARG(1)
        impl.Select(SIZE_ARG(1));
    }
//__ccgen_debug__: `ret name(args)` is `null List()`
    IFCMD("List") {
        WANT_ARG(0)
        impl.List();
    }
//__ccgen_debug__: `ret name(args)` is `null InitBiTree()`
    IFCMD("InitBiTree") {
        WANT_ARG(0)
        impl.InitBiTree();
    }
//__ccgen_debug__: `ret name(args)` is `null DestroyBiTree()`
    IFCMD("DestroyBiTree") {
        WANT_ARG(0)
        impl.DestroyBiTree();
    }
//__ccgen_debug__: `ret name(args)` is `null CreateBiTree()`
    IFCMD("CreateBiTree") {
        WANT_ARG(0)
        impl.CreateBiTree();
    }
//__ccgen_debug__: `ret name(args)` is `null ClearBiTree()`
    IFCMD("ClearBiTree") {
        WANT_ARG(0)
        impl.ClearBiTree();
    }
//__ccgen_debug__: `ret name(args)` is `bool BiTreeEmpty()`
    IFCMD("BiTreeEmpty") {
        WANT_ARG(0)
        HAVE_RETURN_VALUE
        impl.BiTreeEmpty();
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `size_t BiTreeDepth()`
    IFCMD("BiTreeDepth") {
        WANT_ARG(0)
        HAVE_RETURN_VALUE
        impl.BiTreeDepth();
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage Root()`
    IFCMD("Root") {
        WANT_ARG(0)
        HAVE_RETURN_VALUE
        impl.Root();
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `data_t Value(NodeLanguage n)`
    IFCMD("Value") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.Value(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `null Assign(NodeLanguage n, data_t val)`
    IFCMD("Assign") {
        WANT_ARG(2)
        impl.Assign(STRING_ARG(1), INT_ARG(2));
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage Parent(NodeLanguage n)`
    IFCMD("Parent") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.Parent(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage LeftChild(NodeLanguage n)`
    IFCMD("LeftChild") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.LeftChild(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage RightChild(NodeLanguage n)`
    IFCMD("RightChild") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.RightChild(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage LeftSibling(NodeLanguage n)`
    IFCMD("LeftSibling") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.LeftSibling(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `NodeLanguage RightSibling(NodeLanguage n)`
    IFCMD("RightSibling") {
        WANT_ARG(1)
        HAVE_RETURN_VALUE
        impl.RightSibling(STRING_ARG(1));
        PRINT_RETURN_VALUE
    }
//__ccgen_debug__: `ret name(args)` is `null InsertChild(NodeLanguage n, size_t toInsert, size_t LR)`
    IFCMD("InsertChild") {
        WANT_ARG(3)
        impl.InsertChild(STRING_ARG(1), SIZE_ARG(2), SIZE_ARG(3));
    }
//__ccgen_debug__: `ret name(args)` is `null DeleteChild(NodeLanguage n, size_t LR)`
    IFCMD("DeleteChild") {
        WANT_ARG(2)
        impl.DeleteChild(STRING_ARG(1), SIZE_ARG(2));
    }
//__ccgen_debug__: `ret name(args)` is `null PreOrderTraverse()`
    IFCMD("PreOrderTraverse") {
        WANT_ARG(0)
        impl.PreOrderTraverse();
    }
//__ccgen_debug__: `ret name(args)` is `null InOrderTraverse()`
    IFCMD("InOrderTraverse") {
        WANT_ARG(0)
        impl.InOrderTraverse();
    }
//__ccgen_debug__: `ret name(args)` is `null PostOrderTraverse()`
    IFCMD("PostOrderTraverse") {
        WANT_ARG(0)
        impl.PostOrderTraverse();
    }
//__ccgen_debug__: `ret name(args)` is `null LevelOrderTraverse()`
    IFCMD("LevelOrderTraverse") {
        WANT_ARG(0)
        impl.LevelOrderTraverse();
    }

    IFCMD("exit") {
        rlib::println("bye~");
        ::std::exit(0);
    }
    IFCMD("help") {
        help_msg();
    }
    //Code generated by ccgen.py ahead. Do not edit them by hand.
    AREA_END {
        throw std::invalid_argument("Invalid argument. Try to type `help` to get helped.");
    }
 

   }
};

#endif //_HUST___PARSER_HPP
