#ifndef HUST___REFLECTED_IMPL_HPP_
#define HUST___REFLECTED_IMPL_HPP_

/*
 * You should NEVER use this code in ANY consequence,
 *     as these code is just to make hust happy.
 */

#include <utility>
#include <functional>
#include <algorithm>
#include <person.hpp>
#include <db.hpp>

#include <rlib/stdio.hpp>
#include <deque>

using std::to_string;
using std::stoull;
using std::string;
__refl_class__ class reflected_impl {
public:
    using data_t = int;
    using dataref_t = const data_t &;
    reflected_impl() : containers(1), current(containers.begin()) {}

    __refl_func__ void Select(size_t i) {if(i>=containers.size())throw std::runtime_error("invalid index.");current = containers.begin() + i;}
    __refl_func__ void List() {rlib::printfln("You have {} AVLSET now, selecting {}.", containers.size(), current - containers.begin());}
    __refl_func__ void CreateAVLSet() {containers.push_back(r::set<data_t>());}
    __refl_func__ void DestroyAVLSet() {containers.erase(current); current = containers.begin();}

    __refl_func__ void insert(dataref_t what) {
        current->insert(what);
    }
    __refl_func__ void rm(dataref_t what) {
        current->erase(current->find(what));
    }
    __refl_func__ void ls() {
        current->show(rlib::format_string("Set with size {}", current->size()));
    }
    __refl_func__ void merge(size_t another) {
        (*current + containers.at(another)).show();
    }
    __refl_func__ void sub(size_t to_sub) {
        (*current - containers.at(to_sub)).show();
    }
    __refl_func__ void common(size_t another) {
        (*current ^ containers.at(another)).show();
    }
    __refl_func__ bool contains(size_t another) {
        return current -> contain(containers.at(another));
    }
    __refl_func__ bool equal(size_t another) {
        return *current == containers.at(another);
    }
    __refl_func__ void clear() {
        current->clear();
    }
    __refl_func__ void dump() {
        current->dump();
    }

private:
    std::deque<r::set<data_t>> containers;
    decltype(containers.begin()) current;
};
extern reflected_impl impl;

#endif
