#ifndef EXPERIMENT1_H
#define EXPERIMENT1_H

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>


#define TRUE 1
#define FALSE 0
#define OK 1
#define ERROR 0
#define INFEASTABLE -1
#define OVERFLOW -2

typedef int status;
typedef int ElemType;

#define LIST_INIT_SIZE 100
#define LISTINCREMENT 10

#define MAX_SQLIST_NUM 10

typedef struct {
  ElemType *elem;
  int length;
  int listsize;
} SqList;
typedef struct {
  SqList *pSqList[MAX_SQLIST_NUM];
  int length;
} SqLists;

SqLists Lists;

void LoadDate(void);
status CreatList(void);
status SaveDate(void);
extern char *gp_sqlists_filename;
extern char *gp_sqlistdate_filename;
extern char *gp_sqlistelem_filename;

status InitList(SqList *L);
SqList *ChooseList(int *);
status DestroyList(SqList *L);
status ClearList(SqList *L);
status ListEmpty(SqList L);
int ListLength(SqList L);
status GetElem(SqList L, int i, ElemType *e);
status LocateElem(SqList L, ElemType e);
status PriorElem(SqList L, ElemType cur, ElemType *pre_e);
status NextElem(SqList L, ElemType cur, ElemType *next_e);
status ListInsert(SqList *L, int i, ElemType e);
status ListDelete(SqList *L, int i, ElemType *e);
status ListTraverse(SqList L);

#endif /**< EXPERIMENT1_H*/
