#include "experiment1.h"
SqList *ChooseList(size_t *popListNum) {
  size_t choice;
  printf("\n输入编号(1-");
  printf("%d):", Lists.length);
  scanf("%d", &choice);
  getchar();
  if (choice < 1 || choice > Lists.length) {
    printf("\n表不存在\n");
    return NULL;
  }
  *popListNum = choice;
  printf("成功\n");
  return Lists.pSqList[choice - 1];
}
status ClearList(SqList *L) {
  L->length = 0;
  return OK;
}

status CreatList(void) {
  FILE *pFILE;
  SqLists *pLists = &Lists;
  SqList *p_sqList;
  size_t re = 0;
  size_t ListsLength = 0;
  size_t i;
  if ((pFILE = fopen(gp_sqlists_filename, "rb+")) == NULL) {
    fopen(gp_sqlists_filename, "wb+");
    if ((pFILE = fopen(gp_sqlists_filename, "rb+")) == NULL) {
      printf("信息文件打开失败！\n");
      return re;
    }
  }
  printf("信息文件打开成功！\n");
  if (fread(pLists, sizeof(SqLists), 1, pFILE)) {
    re += 4;
    printf("信息文件加载成功！\n");
    ListsLength = pLists->length;
  }
  for (i = 0; i < MAX_SQLIST_NUM; i++) {
    pLists->pSqList[i] = NULL;
  }
  pLists->length = 0;
  fclose(pFILE);
  if ((pFILE = fopen(gp_sqlistdate_filename, "rb+")) == NULL) {
    fopen(gp_sqlistdate_filename, "wb+");
    if ((pFILE = fopen(gp_sqlistdate_filename, "rb+")) == NULL) {
      printf("数据文件打开失败!\n");
      return re;
    }
  }
  printf("数据文件打开成功!\n");
  for (i = 0; i < ListsLength; i++) {
    pLists->pSqList[i] = (SqList *)malloc(sizeof(SqList));
    p_sqList = pLists->pSqList[i];
    if ((fread(p_sqList, sizeof(SqList), 1, pFILE)) == 0) {
      printf("数据文件不完整！\n");
      free(p_sqList);
      return re;
    }
    p_sqList->elem = (ElemType *)malloc(LIST_INIT_SIZE * sizeof(ElemType));
    pLists->length++;
  }
  re += 8;
  printf("数据文件加载成功！\n");
  fclose(pFILE);
  if ((pFILE = fopen(gp_sqlistelem_filename, "rb+")) == NULL) {
    fopen(gp_sqlistelem_filename, "wb+");
    if ((pFILE = fopen(gp_sqlistdate_filename, "rb+")) == NULL) {
      printf("elem数据文件打开失败!\n");
      return re;
    }
  }
  printf("elem数据文件打开成功!\n");
  for (i = 0; i < ListsLength; i++) {
    if ((fread(pLists->pSqList[i]->elem, sizeof(ElemType),
               pLists->pSqList[i]->length, pFILE)) == 0) {
      printf("elem数据文件不完整！\n");
      return re;
    }
  }
  re += 16;
  printf("elem数据文件加载成功！\n");
  fclose(pFILE);
  return re;
}
status DestroyList(SqList *L) {
  free(L->elem);
  free(L);
  return OK;
}
status GetElem(SqList L, size_t i, ElemType *e) {
  *e = L.elem[i - 1];
  return OK;
}
status InitList(SqList *L) {
  L->elem = (ElemType *)malloc(LIST_INIT_SIZE * sizeof(ElemType));
  if (!L->elem)
    exit(OVERFLOW);
  L->length = 0;
  L->listsize = LIST_INIT_SIZE;
  return OK;
}
status ListDelete(SqList *L, size_t i, ElemType *e) {
  ElemType *p, *q;
  if (i < 1 || i > L->length)
    return ERROR;
  p = &L->elem[i - 1];
  *e = *p;
  for (q = &L->elem[L->length - 1]; p < q; p++) {
    *p = *(p + 1);
  }
  L->length--;
  return OK;
}
status ListEmpty(SqList L) { return L.length == 0; }
status ListInsert(SqList *L, size_t i, ElemType e) {
  ElemType *newbase, *p, *q;
  if (i < 1 || i > L->length + 1)
    return ERROR;
  if (L->length >= L->listsize) {
    newbase = (ElemType *)realloc(L->elem, (L->listsize + LISTINCREMENT) *
                                               sizeof(ElemType));
    if (!newbase)
      exit(OVERFLOW);
    L->elem = newbase;
    L->listsize += LISTINCREMENT;
  }
  p = &L->elem[i - 1];
  for (q = &L->elem[L->length - 1]; p <= q; q--) {
    *(q + 1) = *q;
  }
  *p = e;
  L->length++;
  return OK;
}
size_t ListLength(SqList L) { return L.length; }
status ListTraverse(SqList L) {

  printf("\n-----------all elements -----------------------\n");
  for (size_t i = 0; i < L.length; i++)
    printf("%d ", L.elem[i]);
  printf("\n------------------ end ------------------------\n");
  return L.length;
}
void LoadDate(void) {
  size_t Re = CreatList();
  if (Re < 24) {
    /*数据加载提示信息*/
    printf("\n系统数据不完整!\n");
  }
  printf("\n按回车键继续...\n");
  getchar();
  return;
}
status LocateElem(SqList L, ElemType e) {
  size_t i;
  for (i = 0; i < L.length; i++) {
    if (L.elem[i] == e)
      return i + 1;
  }
  return 0;
}
status NextElem(SqList L, ElemType cur, ElemType *next_e) {
  size_t i;
  for (i = 0; i < L.length - 1; i++) {
    if (L.elem[i] == cur) {
      *next_e = L.elem[i + 1];
      return OK;
    }
  }
  return ERROR;
}
status PriorElem(SqList L, ElemType cur, ElemType *pre_e) {
  size_t i;
  for (i = 1; i < L.length; i++) {
    if (L.elem[i] == cur) {
      *pre_e = L.elem[i - 1];
      return OK;
    }
  }
  return ERROR;
}
status SaveDate(void) {
  FILE *pFILE1, *pFILE2;
  SqLists *pLists = &Lists;
  size_t i;
  pFILE1 = fopen(gp_sqlists_filename, "wb");
  fwrite(pLists, sizeof(SqLists), 1, pFILE1);
  fclose(pFILE1);
  pFILE1 = fopen(gp_sqlistdate_filename, "wb");
  pFILE2 = fopen(gp_sqlistelem_filename, "wb");
  for (i = 0; i < pLists->length; i++) {
    fwrite(pLists->pSqList[i], sizeof(SqList), 1, pFILE1);
    fwrite(pLists->pSqList[i]->elem, sizeof(ElemType),
           pLists->pSqList[i]->length, pFILE2);
  }
  fclose(pFILE1);
  fclose(pFILE2);
  return OK;
}
