#ifndef __WATCHPOINT_H__
#define __WATCHPOINT_H__

#include "common.h"

#include <string>
#include <list>
#include <iostream>

#include "monitor/expr.h"

struct WP {
  std::string expr;
  uint32_t curr_value;
  int id;

  bool evalulate() {
    auto new_value = evaluate_expr(expr);
    std::swap(new_value, curr_value);
    return new_value != curr_value;
  }
  WP(std::string e, int id) : expr(e), id(id) {
    evalulate(); // initial expr value.
  }
};

extern std::list<WP> watchpoints;
// WARNING: Not thread-safe
extern int max_watchpoint_id;

inline std::ostream & operator<< (std::ostream &os, const WP &watchpoint) {
  return os << "watchpoint " << watchpoint.id << "{expr=" << watchpoint.expr << ", value=" << num2hex(watchpoint.curr_value) << "}";
}


#endif
