#ifndef RLIB_HUST_UTIL_HPP_
#define RLIB_HUST_UTIL_HPP_ 1

#include <common.h>

namespace rlib {
  template <size_t BytesCount>
  static inline int32_t signed_extend_low_bytes(const int32_t &val) {
    static_assert(BytesCount == 1 || BytesCount == 2 || BytesCount == 4);
    if constexpr(BytesCount == 1)
      return (int8_t)val;
    else if constexpr(BytesCount == 2)
      return (int16_t)val;
    return val;
  }
}

#endif
