#include <gnome-keyring-1/gnome-keyring.h>
#include <string>
#include <rlib/macro.hpp>

#include <libsecret/secret.h>
#include <gmodule.h>
#include <rlib/stdio.hpp>

// TODO: read https://gnome.pages.gitlab.gnome.org/libsecret/class.Service.html
//       https://gnome.pages.gitlab.gnome.org/libsecret/method.Service.prompt.html
inline std::string do_unlock_2(std::string keyring, std::string password) {
    GError *err = NULL;
    SecretService *service_proxy_ptr = secret_service_get_sync(SECRET_SERVICE_LOAD_COLLECTIONS, NULL, &err);
    if(err != NULL or service_proxy_ptr == NULL) {
        return err->message;
    }
    rlib_defer([&]{g_object_unref(service_proxy_ptr);});

    GList *collections = secret_service_get_collections(service_proxy_ptr);
    if(collections == NULL) return "collection gg";

    auto curr = collections;
    while (curr != NULL)
    {
        auto iter = reinterpret_cast<SecretCollection *>(curr->data);
        auto label = secret_collection_get_label(iter);
        if(label == NULL) break;
        rlib_defer([&]{g_free(label);});
        rlib::println("DEBUG: LABEL=", label);

        curr = curr->next;
    }
    return "";
}

inline GnomeKeyringResult do_unlock(std::string keyring, std::string password) {
    return gnome_keyring_unlock_sync(keyring.c_str(), password.c_str());
}

inline std::string keyringResultToString(GnomeKeyringResult res) {
    switch(res) {
#define RLIB_IMPL_GEN_RESULT(value) RLIB_IMPL_GEN_RESULT_1(value, RLIB_MACRO_TO_CSTR(value))
#define RLIB_IMPL_GEN_RESULT_1(value, cstr) case (value): return (cstr)

        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_OK);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_DENIED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_KEYRING_DAEMON);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_ALREADY_UNLOCKED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_SUCH_KEYRING);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_BAD_ARGUMENTS);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_IO_ERROR);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_CANCELLED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_KEYRING_ALREADY_EXISTS);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_MATCH);
        default:
            return std::string("Unknown Result Code: ") + std::to_string(res);
    }
}
