#include <string>
#include <rlib/macro.hpp>
using namespace std::literals;

#if defined(USE_LIBSECRET)
#include <libsecret/secret.h>
#include <gmodule.h>

//GVariant *  hooked_prompt_sync      (SecretService *self,
//                                  SecretPrompt *prompt,
//                                  GCancellable *cancellable,
//                                  const GVariantType *return_type,
//                                  GError **error) {
//    auto original_funcptr = decltype(&hooked_prompt_sync)(gl_original_funcptr);
//    auto res = original_funcptr(self, prompt, cancellable, return_type, error);
//
//    g_variant_ref(res);
//    rlib_defer([&]{ g_variant_unref(res); });
//
//    rlib::println("DEBUG: prompt res typestr: ", g_variant_get_type_string(res));
//
//    gsize output_strlen;
//    auto output_str = g_variant_get_string(res, &output_strlen);
//    // TODO: is this working in utf8 characters?
//    rlib::println("DEBUG: prompt res: ", std::string(output_str, output_strlen));
//
//    return res;
//}

void *gl_original_funcptr = nullptr;
GAsyncReadyCallback gl_real_async_callback = nullptr;
void hooked_fake_callback(GObject *source_object,
                          GAsyncResult *res,
                          gpointer user_dat) {
    rlib::println("HIT");
    // rlib::println(g_async_result_get_user_data(res))
    gl_real_async_callback(source_object, res, user_dat);
}

void        hooked_prompt_async     (SecretService *self,
                                  SecretPrompt *prompt,
                                  const GVariantType *return_type,
                                  GCancellable *cancellable,
                                  GAsyncReadyCallback callback,
                                  gpointer user_data) {
    // TODO: read secret_prompt_perform and secret_prompt_perform_sync
    //       to learn how to call the callback directly.
    gl_real_async_callback = callback;
    rlib::println("return type=", g_variant_type_peek_string(return_type));
    auto original_funcptr = decltype(&hooked_prompt_async)(gl_original_funcptr);
    original_funcptr(self, prompt, return_type, cancellable, &hooked_fake_callback, user_data);
}

inline std::string do_unlock(std::string keyring_label, std::string password) {
    GError *err = NULL;
    SecretService *service_proxy_ptr = secret_service_get_sync(SECRET_SERVICE_LOAD_COLLECTIONS, NULL, &err);
    if(err != NULL or service_proxy_ptr == NULL) {
        return err->message;
    }
    rlib_defer([&]{g_object_unref(service_proxy_ptr);});

    gl_original_funcptr = (void *) SECRET_SERVICE_GET_CLASS(service_proxy_ptr)->prompt_async;
    SECRET_SERVICE_GET_CLASS(service_proxy_ptr)->prompt_async = &hooked_prompt_async;

    GList *collections = secret_service_get_collections(service_proxy_ptr);
    if(collections == NULL) return "collection gg";
    GList *collections_to_unlock = NULL;

    auto curr = collections;
    while (curr != NULL)
    {
        auto iter = reinterpret_cast<SecretCollection *>(curr->data);
        auto label = secret_collection_get_label(iter);
        if(label == NULL) break;
        rlib_defer([&]{g_free(label);});
        if(std::string(label) == keyring_label) {
            collections_to_unlock = g_list_append(collections_to_unlock, iter);
        }

        curr = curr->next;
    }
    if(g_list_length(collections_to_unlock) == 0) {
        return "No such keyring with label: "s + keyring_label + ". You need keyring LABEL instead of NAME. ";
    }

    auto unlocked_count = secret_service_unlock_sync(service_proxy_ptr, collections_to_unlock, NULL, NULL, &err);
    if(unlocked_count == g_list_length(collections_to_unlock))
        return "SUCCESS";
    else {
        std::string err_msg_pass = err == NULL ? "No error message from libsecret" : err->message;
        std::string err_msg_stat = unlocked_count == 0 ? "Failed. " : 
            "Some requested keyrings failed to unlock. "+std::to_string(unlocked_count)+"/"+std::to_string(g_list_length(collections_to_unlock))+" collections(keyrings) successfully unlocked. ";

        return err_msg_stat + err_msg_pass;
    }
}
#define keyringResultToString(r) (r)
constexpr auto UNLOCK_RESULT_SUCCESS = "SUCCESS";

#elif defined(USE_LIBGNOMEKEYRING)
#include <gnome-keyring-1/gnome-keyring.h>

inline GnomeKeyringResult do_unlock(std::string keyring, std::string password) {
    return gnome_keyring_unlock_sync(keyring.c_str(), password.c_str());
}
inline std::string keyringResultToString(GnomeKeyringResult res) {
    switch(res) {
#define RLIB_IMPL_GEN_RESULT(value) RLIB_IMPL_GEN_RESULT_1(value, RLIB_MACRO_TO_CSTR(value))
#define RLIB_IMPL_GEN_RESULT_1(value, cstr) case (value): return (cstr)

        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_OK);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_DENIED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_KEYRING_DAEMON);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_ALREADY_UNLOCKED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_SUCH_KEYRING);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_IO_ERROR);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_CANCELLED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_KEYRING_ALREADY_EXISTS);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_MATCH);

        case GNOME_KEYRING_RESULT_BAD_ARGUMENTS:
            return std::string("GNOME_KEYRING_RESULT_BAD_ARGUMENTS, this error usually caused by incorrect keyring name. You need keyring NAME instead of LABEL. ");
        default:
            return std::string("Unknown Result Code: ") + std::to_string(res);
    }
}
constexpr auto UNLOCK_RESULT_SUCCESS = GNOME_KEYRING_RESULT_OK;

#else

#error You must define either USE_LIBGNOMEKEYRING(deprecated) or USE_LIBSECRET(new), to select which backend implementation to use

#endif

