#include <gnome-keyring-1/gnome-keyring.h>
#include <string>
#include <rlib/macro.hpp>
using namespace std::literals;

#include <libsecret/secret.h>
#include <gmodule.h>
#include <rlib/stdio.hpp>

#if defined(USE_LIBSECRET)
inline std::string do_unlock(std::string keyring_label, std::string password) {
    GError *err = NULL;
    SecretService *service_proxy_ptr = secret_service_get_sync(SECRET_SERVICE_LOAD_COLLECTIONS, NULL, &err);
    if(err != NULL or service_proxy_ptr == NULL) {
        return err->message;
    }
    rlib_defer([&]{g_object_unref(service_proxy_ptr);});

    GList *collections = secret_service_get_collections(service_proxy_ptr);
    if(collections == NULL) return "collection gg";
    GList *collections_to_unlock = NULL;
    GList *collections_unlocked = NULL;

    auto curr = collections;
    while (curr != NULL)
    {
        auto iter = reinterpret_cast<SecretCollection *>(curr->data);
        auto label = secret_collection_get_label(iter);
        if(label == NULL) break;
        rlib_defer([&]{g_free(label);});
        rlib::println("DEBUG: LABEL=", label);
        if(std::string(label) == keyring_label) {
            collections_to_unlock = g_list_append(collections_to_unlock, iter);
            rlib::println("APPEND!");
        }

        curr = curr->next;
    }
    if(g_list_length(collections_to_unlock) == 0) {
        return "No such keyring with label: "s + keyring_label;
    }

    auto unlocked_count = secret_service_unlock_sync(service_proxy_ptr, collections_to_unlock, NULL, &collections_unlocked, &err);
    if(unlocked_count == g_list_length(collections_to_unlock))
        return "SUCCESS";
    else {
        if(err != NULL)
            return rlib::string("{}/{} collections(keyrings) successfully unlocked, some of them failed. Error message: {}").format(unlocked_count, g_list_length(collections_to_unlock), err->message);
        else
            return rlib::string("{}/{} collections(keyrings) successfully unlocked, some of them failed. No error message from libsecret").format(unlocked_count, g_list_length(collections_to_unlock));
    }
}
#define keyringResultToString(r) (r)
constexpr auto UNLOCK_RESULT_SUCCESS = "SUCCESS";
#elif defined(USE_LIBGNOMEKEYRING)
inline GnomeKeyringResult do_unlock(std::string keyring, std::string password) {
    return gnome_keyring_unlock_sync(keyring.c_str(), password.c_str());
}
inline std::string keyringResultToString(GnomeKeyringResult res) {
    switch(res) {
#define RLIB_IMPL_GEN_RESULT(value) RLIB_IMPL_GEN_RESULT_1(value, RLIB_MACRO_TO_CSTR(value))
#define RLIB_IMPL_GEN_RESULT_1(value, cstr) case (value): return (cstr)

        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_OK);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_DENIED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_KEYRING_DAEMON);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_ALREADY_UNLOCKED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_SUCH_KEYRING);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_IO_ERROR);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_CANCELLED);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_KEYRING_ALREADY_EXISTS);
        RLIB_IMPL_GEN_RESULT(GNOME_KEYRING_RESULT_NO_MATCH);

        case GNOME_KEYRING_RESULT_BAD_ARGUMENTS:
            return std::string("GNOME_KEYRING_RESULT_BAD_ARGUMENTS, this error usually caused by incorrect keyring name. You need keyring NAME instead of LABEL. ");
        default:
            return std::string("Unknown Result Code: ") + std::to_string(res);
    }
}
constexpr auto UNLOCK_RESULT_SUCCESS = GNOME_KEYRING_RESULT_OK;
#else
#error You must define either USE_LIBGNOMEKEYRING(deprecated) or USE_LIBSECRET(new), to select which backend implementation to use
#endif

