#!/bin/bash
# Input a vwc, and give a xdc file. Used in vivado wrapper.
# vwc is a much easier format than xdc.

function vwc_cmd () {
    echo $@
}

function vwc_port () {
    echo "set_property PACKAGE_PIN $1 [get_ports {$2}]"
    echo "set_property IOSTANDARD LVCMOS33 [get_ports {$2}]"
}

function vwc_clk () {
    echo "create_clock -add -name sys_clk_pin -period 10.00 -waveform {0 5} [get_ports $1]"
}

[[ $1 == '' ]] && echo "Usage: $0 <path/to/constraint.vwc>" && exit 1
echo '# Generated by Vivado wrapper, licensed under GPL 3.0
# Copyright (C) Recolic Keghart <root@recolic.net>
'
source "$1"
