#!/bin/bash

function burn_file () {
    bit_file="$1"
    dev_name="$2" # Optional

    echo "# Generated by Vivado wrapper, licensed under GPL 3.0
    # Copyright (C) Recolic Keghart <root@recolic.net>
    open_hw
    connect_hw_server
    open_hw_target
    current_hw_device [get_hw_devices ${dev_name}]
    refresh_hw_device -update_hw_probes false [lindex [get_hw_devices ${dev_name}] 0]

    set_property PROBES.FILE {} [get_hw_devices ${dev_name}]
    set_property FULL_PROBES.FILE {} [get_hw_devices ${dev_name}]
    set_property PROGRAM.FILE {${bit_file}} [get_hw_devices ${dev_name}]
    program_hw_devices [get_hw_devices ${dev_name}]
    "
}

if [[ $1 == build ]]; then
    xpr="$2"
    run_name_synth="$3"
    run_name_impl="$4"
    to_step="$5"
    top_mod="$6"
    thread="$7"
    
    proj_dir=`dirname ${xpr}`
    
    echo "# Generated by Vivado wrapper, licensed under GPL 3.0
    # Copyright (C) Recolic Keghart <root@recolic.net>
    open_project ${xpr}
    `find ${proj_dir}/*.srcs -regex '^.*\.s?vh?$' -exec echo add_files \{\} \;`
    set_property top ${top_mod} [current_fileset]
    reset_run ${run_name_synth}
    reset_run ${run_name_impl}
    launch_runs ${run_name_synth} -jobs ${thread}
    wait_on_run ${run_name_synth}
    launch_runs ${run_name_impl} -to_step ${to_step} -jobs ${thread}
    wait_on_run ${run_name_impl}
    "
elif [[ $1 == burn ]]; then
    xpr="$2"
    run_name_impl="$3"
    top_mod="$4"
    dev_name="$5" #Optional

    proj_dir=`dirname ${xpr}`
    bit_file=`ls ${proj_dir}/*.runs/${run_name_impl}/${top_mod}.bit`
    [[ $bit_file == '' ]] && echo "bit_file not found in project. terminating..." && exit 3

    burn_file $bit_file $dev_name
elif [[ $1 == burn-file ]]; then
    burn_file $2 $3
elif [[ $1 == gui ]]; then
    xpr="$2"
    proj_dir=`dirname ${xpr}`
    echo "open_project ${xpr}
    `find ${proj_dir}/*.srcs -regex '^.*\.s?vh?$' -exec echo add_files \{\} \;`
    start_gui"
else
    echo "Usage: $0 build <xpr path> <run_name_synth> <run_name_impl> <to_step> <top module name> <threads_num>
       $0 burn <xpr path> <run_name_impl> <top_module_name> <dev_name(Ex:xc7a100t_0)>"
    exit 1
fi

