#include "cpu/exec.h"
#include "device/port-io.h"

void difftest_skip_ref();
void difftest_skip_dut();

namespace EHelperImpl {
  make_EHelper(lidt) {
    TODO();
  
    print_asm_template1(lidt);
  }
  
  make_EHelper(mov_r2cr) {
    TODO();
  
    print_asm("movl %%%s,%%cr%d", reg_name(id_src->reg, 4), id_dest->reg);
  }
  
  make_EHelper(mov_cr2r) {
    TODO();
  
    print_asm("movl %%cr%d,%%%s", id_src->reg, reg_name(id_dest->reg, 4));
  
  #if defined(DIFF_TEST)
    difftest_skip_ref();
  #endif
  }
  
  make_EHelper(int_) {
    TODO();
  
    print_asm("int %s", id_dest->str);
  
  #if defined(DIFF_TEST) && defined(DIFF_TEST_QEMU)
    difftest_skip_dut();
  #endif
  }
  
  make_EHelper(iret) {
    TODO();
  
    print_asm("iret");
  }
  
  make_EHelper(in) {
    rtlreg_t tmp;
  	switch(id_src->width)
  	{
  		case 1: tmp = pio_read_common<1>(id_src->val); break;
  		case 2: tmp = pio_read_common<2>(id_src->val); break;
  		case 4: tmp = pio_read_common<4>(id_src->val); break;
  	}
  	operand_write(id_dest, &tmp);
  
    print_asm_template2(in);
  
  #if defined(DIFF_TEST)
    difftest_skip_ref();
  #endif
  }
  
  make_EHelper(out) {
	  switch(id_src->width)
	  {
	  	case 1: pio_write_common<1>(id_dest->val, id_src->val); break;
	  	case 2: pio_write_common<2>(id_dest->val, id_src->val); break;
	  	case 4: pio_write_common<4>(id_dest->val, id_src->val); break;
	  }

    print_asm_template2(out);
  
  #if defined(DIFF_TEST)
    difftest_skip_ref();
  #endif
  }
} // end namespace
