%option noyywrap

%{

#define YY_DECL int yylex()

#include "parser.tab.h"
#include <stdint.h>

%}

%%

[ \t\n]       {}
0x[0-9]+      {yylval.ival = (int)strtol(yytext, NULL, 16); return T_INT;}
[0-9]+        {yylval.ival = atoi(yytext); return T_INT;}
"=="          {return T_EQUAL;}
"!="          {return T_NEQUAL;}
"&&"          {return T_LOGICAL_AND;}
[-+*/()]      {return yytext[0];}

"%"[a-z]{3}   {yylval.ival = ((uint32_t)yytext[1] << 8) + yytext[2]; return T_REG;}
%%
// Registers: eax='a'+'x', ebx='b'+'x', ...
